<%@ page language="java" contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE HTML>
<html>
<head>
<title>PSS勘查平台</title>
<link href="<c:url value='/resources/css/wechat/newweui.css'/>" rel="stylesheet"type="text/css">

<script type="text/javascript" src="<c:url value='/resources/js/jquery-2.1.1.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	$(function(){
		var _check = '${check}';
		if(_check == '2'){
			showMenu('survey');
		} else if(_check == '3'){
			showMenu('venue');
		} else {
			showMenu('personCenter');
		}
	})

	function showMenu(objId) {
		$(".weui-cells").hide();
		$("#_" + objId).show();
	}

	function hideMenu(objId) {
		$("#" + objId).hide();
	}
	function showSign(){
		var title="勘查人员签名";
		layer.open({
			type: 2,
			title: title,
			closeBtn: 0,
			shadeClose: false,
			scrollbar: false,
			area: ['100%', '100%'],
			content: baseUrl + '/wechat/survey/showSign'
		});
	}
</script>
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
</head>
<body>
	<div class="weui-panel weui-panel_access">

		<div class="weui-panel__bd">
			<a aria-labelledby="js_p1m1_bd" href="javascript:" class="weui-media-box weui-media-box_appmsg">
				<div aria-hidden="true" class="weui-media-box__hd">
					<img class="weui-media-box__thumb" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHgAAAB4CAMAAAAOusbgAAAAeFBMVEUAwAD///+U5ZTc9twOww7G8MYwzDCH4YcfyR9x23Hw+/DY9dhm2WZG0kbT9NP0/PTL8sux7LFe115T1VM+zz7i+OIXxhes6qxr2mvA8MCe6J6M4oz6/frr+us5zjn2/fa67rqB4IF13XWn6ad83nxa1loqyirn+eccHxx4AAAC/klEQVRo3u2W2ZKiQBBF8wpCNSCyLwri7v//4bRIFVXoTBBB+DAReV5sG6lTXDITiGEYhmEYhmEYhmEYhmEY5v9i5fsZGRx9PyGDne8f6K9cfd+mKXe1yNG/0CcqYE86AkBMBh66f20deBc7wA/1WFiTwvSEpBMA2JJOBsSLxe/4QEEaJRrASP8EVF8Q74GbmevKg0saa0B8QbwBdjRyADYxIhqxAZ++IKYtciPXLQVG+imw+oo4Bu56rjEJ4GYsvPmKOAB+xlz7L5aevqUXuePWVhvWJ4eWiwUQ67mK51qPj4dFDMlRLBZTqF3SDvmr4BwtkECu5gHWPkmDfQh02WLxXuvbvC8ku8F57GsI5e0CmUwLz1kq3kD17R1In5816rGvQ5VMk5FEtIiWislTffuDpl/k/PzscdQsv8r9qWq4LRWX6tQYtTxvI3XyrwdyQxChXioOngH3dLgOFjk0all56XRi/wDFQrGQU3Os5t0wJu1GNtNKHdPqYaGYQuRDfbfDf26AGLYSyGS3ZAK4S8XuoAlxGSdYMKwqZKM9XJMtyqXi7HX/CiAZS6d8bSVUz5J36mEMFDTlAFQzxOT1dzLRljjB6+++ejFqka+mXIe6F59mw22OuOw1F4T6lg/9VjL1rLDoI9Xzl1MSYDNHnPQnt3D1EE7PrXjye/3pVpr1Z45hMUdcACc5NVQI0bOdS1WA0wuz73e7/5TNqBPhQXPEFGJNV2zNqWI7QKBd2Gn6AiBko02zuAOXeWIXjV0jNqdKegaE/kJQ6Bfs4aju04lMLkA2T5wBSYPKDGF3RKhFYEa6A1L1LG2yacmsaZ6YPOSAMKNsO+N5dNTfkc5Aqe26uxHpx7ZirvgCwJpWq/lmX1hA7LyabQ34tt5RiJKXSwQ+0KU0V5xg+hZrd4Bn1n4EID+WkQdgLfRNtvil9SPfwy+WQ7PFBWQz6dGWZBLkeJFXZGCfLUjCgGgqXo5TuSu3cugdcTv/HjqnBTEMwzAMwzAMwzAMwzAMw/zf/AFbXiOA6frlMAAAAABJRU5ErkJggg==" alt="" style="width:80px;height:80px;border-radius:40px;">
				</div>
				<div aria-hidden="true" id="js_p1m1_bd" class="weui-media-box__bd">
					<strong class="weui-media-box__title">${currentUser.realName}</strong>
				</div>
			</a>
		</div>

	</div>





	<div class="weui-cells" id="_personCenter" hidden>
		<div class="weui-cell weui-cell_access" onclick="javascript:location.href='/wechat/task/taskList/init'">
			<span class="weui-cell__bd">
			  <span>我的任务</span>
			</span>
			<span class="weui-cell__ft">
			  <span id="logo"></span>
			</span>
		</div>
		<div class="weui-cell weui-cell_access" onclick="javascript:location.href='/wechat/plan/surveyPlan/init'">
			<span class="weui-cell__bd">
			  <span>我的日程</span>
			</span>
			<span class="weui-cell__ft">
			  <span id="logo"></span>
			</span>
		</div>
	</div>

	<div class="weui-cells" id="_survey" hidden>
		<div class="weui-cell weui-cell_access" onclick="javascript:location.href='/wechat/question/init'">
			<span class="weui-cell__bd">
			  <span>勘查问卷</span>
			</span>
			<span class="weui-cell__ft">
			  <span id="logo"></span>
			</span>
		</div>
		<div class="weui-cell weui-cell_access" onclick="javascript:location.href='/wechat/survey/siteSurvey/init'">
			<span class="weui-cell__bd">
			  <span>开始勘查</span>
			</span>
			<span class="weui-cell__ft">
			  <span id="logo"></span>
			</span>
		</div>
	</div>

	<div class="weui-cells" id="_venue" hidden>
		<div class="weui-cell weui-cell_access" onclick="javascript:location.href='/wechat/venue/addVenue/init'">
			<span class="weui-cell__bd">
			  <span>新增场馆</span>
			</span>
			<span class="weui-cell__ft">
			  <span id="logo"></span>
			</span>
		</div>
		<div class="weui-cell weui-cell_access" onclick="javascript:location.href='/wechat/venue/venueList/init'">
			<span class="weui-cell__bd">
			  <span>修改场馆</span>
			</span>
			<span class="weui-cell__ft">
			  <span id="logo"></span>
			</span>
		</div>
	</div>


	<div class="weui-tabbar">
		<a href="javascript:void(0);" class="weui-tabbar__item"
			onclick="showMenu('personCenter')">
			<p class="weui-tabbar__label weui-media__title">个人中心</p>
		</a> 
		<a href="javascript:void(0);" class="weui-tabbar__item" onclick="showMenu('survey')">
			<p class="weui-tabbar__label weui-media__title">现场勘查</p>
		</a> 
		<a href="javascript:void(0);" class="weui-tabbar__item" onclick="showMenu('venue')">
			<p class="weui-tabbar__label weui-media__title">场馆维护</p>
		</a>
	</div>

	<%--<div id="personCenter" style="display: none;">
		<div class="weui-mask_transparent actionsheet__mask actionsheet__mask_show"
			style="display: block; transform-origin: 0px 0px 0px; opacity: 1; transform: scale(1, 1);"></div>
		<div class="weui-actionsheet weui-actionsheet_toggle" id="weui-actionsheet">
			<div class="weui-actionsheet__menu">
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/task/taskList/init'/>" target="_blank">我的任务</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/plan/surveyPlan/init'/>" target="_blank">我的日程</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/j_spring_security_logout'/>" target="_blank">退出</a>
				</div>
			</div>
			<div class="weui-actionsheet__action">
				<div class="weui-actionsheet__cell" id="actionsheet_cancel" onclick="hideMenu('personCenter')">取消</div>
			</div>
		</div>
	</div>


	<div id="survey" style="display: none;">
		<div class="weui-mask_transparent actionsheet__mask actionsheet__mask_show"
			style="display: block; transform-origin: 0px 0px 0px; opacity: 1; transform: scale(1, 1);"></div>
		<div class="weui-actionsheet weui-actionsheet_toggle" id="weui-actionsheet">
			<div class="weui-actionsheet__menu">
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/question/init'/>" target="_blank">勘查问卷</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/survey/siteSurvey/init'/>" target="_blank">开始勘查</a>
				</div>
			</div>
			<div class="weui-actionsheet__action">
				<div class="weui-actionsheet__cell" id="actionsheet_cancel" onclick="hideMenu('survey')">取消</div>
			</div>
		</div>
	</div>


	<div id="venue" style="display: none;">
		<div class="weui-mask_transparent actionsheet__mask actionsheet__mask_show"
			style="display: block; transform-origin: 0px 0px 0px; opacity: 1; transform: scale(1, 1);"></div>
		<div class="weui-actionsheet weui-actionsheet_toggle" id="weui-actionsheet">
			<div class="weui-actionsheet__menu">
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/venue/addVenue/init'/>" target="_blank">新增场馆</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/venue/venueList/init'/>" target="_blank">修改场馆</a>
				</div>
			</div>
			<div class="weui-actionsheet__action">
				<div class="weui-actionsheet__cell" id="actionsheet_cancel" onclick="hideMenu('venue')">取消</div>
			</div>
		</div>
	</div>--%>

</body>
</html>