<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>

<head>
	<%@include file="/WEB-INF/views/include/head.jsp" %>
</head>
<%@ page isELIgnored="false"%>
<body>
<div class="pageContent" >
	<div class="row">
       <div class="col-sm-12">
           <div class="ibox float-e-margins">
               <div class="ibox-title">
                   <h5>勘查人员信息</h5>
               </div>
               <div class="ibox-content">
                   <form class="form-horizontal m-t" method="post" id="addUser" action="<c:url value='/manage/user/addUser.json' />" class="pageForm required-validate" onsubmit="return validateCallback(this);">
                       <div class="form-group">
                           <label class="col-sm-3 control-label">账号名：</label>
                           <div class="col-sm-8">
                              <input id="userName" name="userName" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">真实姓名：</label>
                           <div class="col-sm-8">
                              <input id="realName" name="realName" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">密码：</label>
                           <div class="col-sm-8">
                               <input id="password" name="password" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">手机号：</label>
                           <div class="col-sm-8">
                               <input id="phone" name="phone" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">邮箱：</label>
                           <div class="col-sm-8">
                               <input id="email" name="email" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">角色：</label>
                           <div class="col-sm-8">
                               <select name="userRoles"  class="form-control">
									<option value="CM">勘查人员</option>
									<c:forEach items="${currentUser.userRoles.split('#') }" var="userRole">
									<c:if test="${userRole eq 'ADMIN' }">
										<option value="PM">项目经理</option>
									</c:if>
									</c:forEach>
									<option value="EXPERT">专家</option>
                               </select>
                           </div>
                       </div>
                   </form>
               </div>
           </div>
       </div>
   </div>
</div>
<%@include file="/WEB-INF/views/include/foot.jsp" %>
<script type="text/javascript">
$('form').validate();
</script>
</body>
</html>