package com.bcxin.survey.utils;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.data.Region;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 城市地区工具类
 */
@Service
public class SysRegionUtil {

	@Autowired
	private BaseDao baseDao;
	
    //@Cacheable(value="sysCache", key="'regionMap'", sync=true)
    public Map<String,Region> regionMap(){
        List<Region> rList = selectRegionList();
        Map<String,Region> regionMap = Maps.newHashMap();
        for( Region region:rList){
            regionMap.put(region.getOid()+"",region);
        }
        return regionMap;
    }

    public List<Region> selectRegionList(){
    	return baseDao.findAll(Region.class);
    }
    
    public Region findRegionById(Long id){
    	return baseDao.get(Region.class, id);
    }
    
    public Region findRegionByName(String name,String level){
    	List<Criterion> criterionList = new ArrayList<Criterion>();
		if(StringUtil.isNotEmpty(level)) {
			criterionList.add(Restrictions.eq("level", level));
			if(level.equals("1")){
				criterionList.add(Restrictions.eq("province", name));
			}
			if(level.equals("2")){
				criterionList.add(Restrictions.eq("city", name));
			}
			if(level.equals("3")){
				criterionList.add(Restrictions.eq("area", name));
			}
		}
		List<Region> regions = baseDao.findByCriterion(Region.class, criterionList);
		if(regions != null && regions.size() >0) {
            return regions.get(0);
        }
		return null;
    }

    //@Cacheable(value="sysCache", key="'provinceMap'", sync=true)
    public Collection<Region> provinceMap(){
        Collection<Region> regions = Lists.newArrayList();
        Map<String,Region> regionMap = regionMap();
        Set keySet = regionMap.keySet();
        for(Iterator it = keySet.iterator();it.hasNext();){
            Object key = it.next();
            Region region = regionMap.get(key);
            if ( StringUtil.isNotEmpty(region.getProvince()) ) {
                regions.add(region);
            }
        }
        return regions;
    }

    //@Cacheable(value="sysCache", key="'cityMap'", sync=true)
    public Map<String,Collection<Region>> cityMap(){
        Multimap<String, Region> cMap = ArrayListMultimap.create();
        Map<String,Region> regionMap = regionMap();
        Set keySet = regionMap.keySet();
        for(Iterator it = keySet.iterator();it.hasNext();){
            Object key = it.next();
            Region region = regionMap.get(key);
            if ( StringUtil.isNotEmpty(region.getCity()) ) {
                cMap.put(region.getParent_id()+"",region);
            }
        }
        return cMap.asMap();
    }

    //@Cacheable(value="sysCache", key="'areaMap'", sync=true)
    public Map<String,Collection<Region>> areaMap(){
        Multimap<String, Region> aMap = ArrayListMultimap.create();
        Map<String,Region> regionMap = regionMap();
        Set keySet = regionMap.keySet();
        for(Iterator it = keySet.iterator();it.hasNext();){
            Object key = it.next();
            Region region = regionMap.get(key);
            if ( StringUtil.isNotEmpty(region.getArea()) ) {
                aMap.put(region.getParent_id()+"",region);
            }
        }
        return aMap.asMap();
    }

    /**
     * 通过ID返回地区
     * @param id
     * @return
     */
    public Region getRegionById(String id){
        return regionMap().get(id);
    }

}
