package com.bcxin.survey.service.venue;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.survey.dao.venue.VenueBaseDao;
import com.bcxin.survey.dao.venue.VenueFieldsetDao;
import com.bcxin.survey.domain.data.Region;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.venue.VenueBase;
import com.bcxin.survey.domain.venue.VenueFieldset;
import com.bcxin.survey.domain.wechat.AccessToken;
import com.bcxin.survey.dto.AjaxResult;
import com.bcxin.survey.dto.ComposeVenueSearchDto;
import com.bcxin.survey.enums.report.FieldType;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.wechat.AccessTokenService;
import com.bcxin.survey.utils.*;
import com.bcxin.survey.vo.DwzPage;
import com.bcxin.survey.vo.VenueInputDto;
import com.bcxin.survey.wechat.utils.WeixinUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Service
@Transactional
public class ComposeVenueManageServiceImpl implements ComposeVenueManageService {

	@Autowired
	private VenueBaseDao venueBaseDao;

	@Autowired
	private VenueFieldsetDao venueFieldsetDao;

	@Autowired
	private UserService userService;

	@Autowired
	private SysRegionUtil sysRegionUtil;

	@Autowired
	private AccessTokenService accessTokenService;

	/**
	 * 根据场馆类型获取场馆字段信息
	 */
	@Override
	public List<VenueInputDto> getVenueInputsByVenueType(String venueType){
		List<VenueInputDto> venueInputs = new ArrayList<VenueInputDto>();
		try {
			VenueFieldset fieldset = venueFieldsetDao.findByVenueType(venueType);
			String fieldStr = fieldset.getFieldset();
			String[] fields = fieldStr.split("</field:");
			for (String field : fields) {
				if(field.indexOf(" ")>-1){
					VenueInputDto venueInput = new VenueInputDto();
					venueInput.setFieldName(field.substring(field.indexOf("<field:"), field.indexOf(" ")).replace("<field:", ""));
					if(venueInput.getFieldName().equals("name")){
						venueInput.setRequired(true);
					}
					if(field.contains("itemname")){
						String itemnameStr = field.substring(field.indexOf("itemname="));
						venueInput.setItemName(itemnameStr.substring(1, itemnameStr.indexOf("\" ")).replace("temname=\"", ""));
					}
					if(field.contains("type")){
						String typeStr = field.substring(field.indexOf("type="));
						String type = typeStr.substring(0, typeStr.indexOf("\" ")).replace("type=\"", "");
						venueInput.setFiledType(type);
						venueInput.setType(type);
					}

					if(field.contains("maxlength")){
						String maxlengthStr = field.substring(field.indexOf("maxlength="));
						venueInput.setMaxLength(maxlengthStr.substring(0, maxlengthStr.indexOf("\" ")).replace("maxlength=\"", ""));
					}
					if(field.contains("placeholder")){
						String placeholderStr = field.substring(field.indexOf("placeholder="));
						String placeholder = placeholderStr.substring(0, placeholderStr.indexOf("\" ")).replace("placeholder=\"", "");
						venueInput.setPlaceholder(placeholder);
					}
					if(field.contains("default")){
						String defaultStr = field.substring(field.indexOf("default="));
						venueInput.setOptions(defaultStr.substring(0, defaultStr.indexOf("\" ")).replace("default=\"", ""));
					}
					venueInputs.add(venueInput);
				}
			}
		} catch (Exception e) {
			System.out.println(e);
		}
		return venueInputs;
	}

	
	/**
	 * 通过场馆类型、省份、城市、场馆名搜索场馆列表
	 */
	@Override
	public List<VenueBase> queryVenueList(ComposeVenueSearchDto searchDto, DwzPage dwzPage) {
		User currentUser = userService.getCurrentUser();
		searchDto.setUserId(currentUser.getOid());
		List<VenueBase> list = venueBaseDao.queryVenueList(searchDto,dwzPage);
		list.forEach(venueBase -> {
			if(StringUtil.isNotEmpty(venueBase.getProvince())) {
				Region province = sysRegionUtil.getRegionById(venueBase.getProvince());
				venueBase.setProvinceName(province.getProvince());
			}
			if(StringUtil.isNotEmpty(venueBase.getCity())) {
				Region city = sysRegionUtil.getRegionById(venueBase.getCity());
				venueBase.setCityName(city.getCity());
			}
		});
		return list;
	}

	@Override
	public AjaxResult saveOrUpdate(VenueBase venueBase, HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Map<String, String> requestData = HttpUtil.getAllRequestParam(request);
		User currentUser = userService.getCurrentUser();
		String message = "";
		String nature = StringUtil.isNotEmpty(venueBase.getNature()) ? venueBase.getNature():"0";
		String venueType = venueBase.getVenueType();
		message = checkVenueInput(requestData, venueBase, request);
		if(StringUtil.isEmpty(message)) {
			try {
				Class clazz = VenueBase.venueBaseInit(venueType).getClass();
				if(venueBase.getOid() != null){
					venueBaseDao.get(clazz,venueBase.getOid());
					venueBase = (VenueBase)venueBaseDao.get(clazz,venueBase.getOid());
				}else{
					venueBase = VenueBase.venueBaseInit(venueType);
					venueBase.setUserId(currentUser.getOid());
				}
				venueBase.setNature(nature);
				BeanUtils.populate(venueBase,requestData);
				venueBaseDao.saveOrUpdate(venueBase);
				result.setData(venueBase.getOid());
				result.setSuccessful(true);
				result.setMsg(Tips_CN.OP_SUCCEED);
			}catch (Exception e){
				result.setSuccessful(false);
				result.setMsg(Tips_CN.OP_FAILURE);
			}
		}else{
			result.setSuccessful(false);
			result.setMsg(message);
		}
		return result;
	}

	@Override
	public List<VenueInputDto> queryVenueListByVenueIdAndType(Long oid, String venueType) {
		List<VenueInputDto> venueInputs= getVenueInputsByVenueType(venueType);
		Class clazz = VenueBase.venueBaseInit(venueType).getClass();
		VenueBase venue = (VenueBase)venueBaseDao.get(clazz,oid);
		venueInputs.forEach(venueInput->{
			Object fieldValue = BeanUtil.getFieldValue(venue, venueInput.getFieldName());
			if(fieldValue != null){
				venueInput.setValue(fieldValue.toString());
			}
		});
		return venueInputs;
	}

	@Override
	public Map<String, String> delete(Long oid) {
		try {
			VenueBase venueBase = venueBaseDao.get(VenueBase.class,oid);
			venueBaseDao.delete(venueBase);
			return DWZUtil.returnSuccessJson(Tips_CN.OP_SUCCEED, "composeVenueList", "closeCurrent", "composeVenue/list/init");
		}catch (Exception e){
			return DWZUtil.returnFailedJson(Tips_CN.OP_FAILURE, "composeVenueList", "closeCurrent", "");
		}
	}

	@Override
	public VenueBase findById(Long oid) {
		return venueBaseDao.get(VenueBase.class,oid);
	}

	@Override
	public List<VenueBase> getVenueByType(ComposeVenueSearchDto searchDto) {
		return venueBaseDao.getVenueByType(searchDto);
	}

	/**
	 * 检查处理输入的场馆信息
	 * @param requestData
	 * @param venueBase
	 * @param request
	 * @return
	 */
	private String checkVenueInput(Map<String, String> requestData,VenueBase venueBase, HttpServletRequest request){
		String message = "";
		if(StringUtil.isEmpty(venueBase.getName())){
			message = message + "请填写场地名称！<br/>";
		}
		if(StringUtil.isEmpty(venueBase.getVenueType())){
			message = message + "请正确选择场地类型！<br/>";
		}
		if(StringUtil.isEmpty(venueBase.getProvince())){
			message = message + "省份请正确选择！<br/>";
		}
		if(StringUtil.isEmpty(venueBase.getCity())){
			message = message + "城市请正确选择！<br/>";
		}

		if(StringUtil.isEmpty(message)){
			VenueBase bdVenueBase = venueBaseDao.findVenue(venueBase);
			if(bdVenueBase != null){
				if(venueBase.getOid() == null || !bdVenueBase.getOid().toString().equals(venueBase.getOid().toString())){
					message = "该场馆已存在！";
				}
			}
			if(StringUtil.isEmpty(message)){
				List<VenueInputDto> venueInputs= getVenueInputsByVenueType(venueBase.getVenueType());
				for (VenueInputDto venueInput : venueInputs) {
					String fieldData = requestData.get(venueInput.getFieldName());
					String defaultData = "";

					if(venueInput.getFieldType().equals(FieldType.CHECKBOX)){
						String[] datas = request.getParameterValues(venueInput.getFieldName());
						fieldData = "";
						if(datas != null && datas.length >0) {
							for (String data : datas) {
								if (StringUtil.isNotEmpty(fieldData)) {
									fieldData = fieldData + "," + data;
								}
								else {
									fieldData = data;
								}
							}
						}
					}else if(venueInput.getFieldType().equals(FieldType.IMAGE)){
						if(StringUtil.isNotEmpty(fieldData)){
							AccessToken accessToken = accessTokenService.getAccessToken();
							String fileName =  System.currentTimeMillis() + ".jpg";//随机生成新文件名
							String path = ConfigUtil.envi() + "/survey/" + DateUtil.getCurrentDate(DateUtil.FORMAT2)+"/";
							String savePath = ConfigUtil.material() + path;
							boolean result = WeixinUtil.downloadImg(accessToken, fieldData, fileName, savePath);

							if(result){
								fieldData = GlobalResources.WEB_URL + "/getResource.do?path=" + path + fileName;
							}
							else {
								message = message + venueInput.getItemName() + "图片上传失败<br/>";
							}
						}
					}

					if(StringUtil.isNotEmpty(fieldData)){
						if(venueInput.getType().equals("float")){
							if(!ValidatorUtil.isFloat(fieldData)){
								message = message + venueInput.getItemName()+ "请输入正确！(浮点型)<br/>";
							}
						}
						if(venueInput.getType().equals("int")){
							if(!ValidatorUtil.isNumeric(fieldData)){
								message = message + venueInput.getItemName()+ "请输入正确！(整型)<br/>";
							}
						}
						if(venueInput.getFieldType().equals(FieldType.DATE)){
							if(!DateUtil.checkDate(fieldData)){
								message = message + venueInput.getItemName()+ "请选择正确！<br/>";
							}
						}
					}
					requestData.put(venueInput.getFieldName(),StringUtil.isNotEmpty(fieldData)? fieldData:defaultData);
				}
			}
		}
		return message;
	}

}
