package com.bcxin.survey.enums.expert;

public enum ExpertTaskStatusEnum {

    UN_ACCEPT("100","待接单"),
    ACCEPT("200","已接单"),
    REFUSE("300","已拒绝"),
    FINISH("400","已完成"),
    CANCEL("500","已取消");

    private String key;
    private String alias;

    ExpertTaskStatusEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(ExpertTaskStatusEnum e : ExpertTaskStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
