package com.bcxin.survey.domain.log;

import com.bcxin.survey.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * @author hzp
 * 系统日志
 */
@Entity
@Table(name = "RISK_SysLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class SysLog extends BaseBean {

    private static final long serialVersionUID = 1L;

    private Long object_id;

    private String object;

    //日志类型（字典）
    private String logType;

    private String content;

    private String exception;

    private String url;

    private String reqParam;

    private String userAgent;

    private String ip;

    private String method;
}
