package com.bcxin.survey.domain.activity;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.security.Org;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 * 报告所选择的服务机构，合作的价格
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Activity_Cooper")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityCooper extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;
	
	@ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "org_id")
	private Org org;
	
	private BigDecimal amount = BigDecimal.ZERO;
	
	private String paymentMode; //支付方式 （字典）


	
}
