package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.domain.wechat.AccessToken;
import com.bcxin.survey.enums.report.SurveyTaskStatus;
import com.bcxin.survey.service.manage.TaskManageService;
import com.bcxin.survey.service.wechat.AccessTokenService;
import com.bcxin.survey.service.wechat.SurveyQuestionnaireService;
import com.bcxin.survey.service.wechat.SurveyTaskService;
import com.bcxin.survey.utils.DateUtil;
import com.bcxin.survey.utils.GlobalResources;
import com.bcxin.survey.wechat.response.DataDetail;
import com.bcxin.survey.wechat.response.TaskData;
import com.bcxin.survey.wechat.response.TaskNoticeTemplate;
import com.bcxin.survey.wechat.response.TemplateMsg;
import com.bcxin.survey.wechat.utils.WeixinUtil;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

//import com.bcxin.survey.service.DataMigrationService;
//import com.bcxin.survey.service.report.ReportService;


@Controller
@RequestMapping("/test")
public class WechatTestController extends BaseController {

	@Autowired
	private AccessTokenService accessTokenService;	

	@Autowired
	private SurveyTaskService surveyTaskService;
	
	@Autowired
	private TaskManageService taskManageService;
	
	@Autowired
	private SurveyQuestionnaireService surveyQuestionnaireService;

//	@Autowired
//	private DataMigrationService dataMigrationService;
	
//	@Autowired
//	private ReportService reportService;
	
	@RequestMapping("index")
	public ModelAndView index(){
		ModelAndView view = new ModelAndView("/wechat/index");
		return view;
	}
	
	@RequestMapping("dataMigration")
	public void dataMigration(){
//		Report report = reportService.getReportById(Long.parseLong("4587529"));
//		dataMigrationService.dataMigrationByReport(report );
//		dataMigrationService.postProcessing();
	}
	
	@RequestMapping("createSurveyReport/{oid}")
	public ModelAndView createSurveyReport(HttpServletRequest request,@PathVariable Long oid){
		ModelAndView view = new ModelAndView("/wechat/index");
		/*List<Survey_Questionnaire> questionnaires = surveyQuestionnaireService.findAllCompleteQuestionnaire();
		for (Survey_Questionnaire survey_Questionnaire : questionnaires) {
			surveyQuestionnaireService.createSurveyReport(survey_Questionnaire.getOid(),request);
		}*/
		Survey_Questionnaire survey_Questionnaire = surveyQuestionnaireService.findQuestionnaireByOid(oid);
		surveyQuestionnaireService.createSurveyReport(survey_Questionnaire,null);
		
		return view;
	}
	
	@RequestMapping("/sendTemplateMsg")
	public void sendTemplateMsg(){
		GlobalResources res= new GlobalResources();
		TemplateMsg templateMsg = TemplateMsg.createTemplateMsg();
		templateMsg.setTouser("ooZL6jg9IJn4OICJ5AZHuu1hyYKk");
		templateMsg.setUrl("");
		templateMsg.setTemplate_id(res.TASKTEMPLATEID);
		templateMsg.getData().getFirst().setValue("小林");
		templateMsg.getData().getFirst().setColor("#173177");
		templateMsg.getData().getProduct().setValue("1212");
		templateMsg.getData().getProduct().setColor("#173177");
		templateMsg.getData().getPrice().setValue("集美");
		templateMsg.getData().getPrice().setColor("#173177");
		templateMsg.getData().getTime().setValue("1天");
		templateMsg.getData().getTime().setColor("#173177");
		templateMsg.getData().getRemark().setValue("程远");
		templateMsg.getData().getRemark().setColor("#173177");
		AccessToken accessToken = accessTokenService.getAccessToken();
		if(WeixinUtil.sendTemplateMsg(templateMsg,accessToken)){
			System.out.println("发送OK");
		}else {
			System.out.println("发送失败");
		}
	}
	@RequestMapping("sendUnReceiveTaskMsgForCM")
	public void sendUnReceiveTaskMsgForCM(){
		taskManageService.sendUnReceiveTaskMsgForPM();
	}
	
	
	@RequestMapping("sendTask")
	public void sendTask(){
		List<SurveyTask> list = surveyTaskService.findSurveyTaskListByStatus(SurveyTaskStatus.DISTRIBUTE);
		GlobalResources res= new GlobalResources();
		for(SurveyTask surveyTask : list){
			TaskNoticeTemplate taskNotice = new TaskNoticeTemplate();
//			taskNotice.setTouser(surveyTask.getSurveyMan().getOpenId());
			taskNotice.setUrl("");
			taskNotice.setTemplate_id(res.TASKTEMPLATEID);

			DataDetail keyword1 = new DataDetail();
			DataDetail keyword2 = new DataDetail();
			DataDetail keyword3 = new DataDetail();
			DataDetail first = new DataDetail();
			DataDetail remark = new DataDetail();

			first.setValue("您有新的任务");
			first.setColor("#173177");
			keyword1.setValue(surveyTask.getTaskCode());
			keyword1.setColor("#173177");
			keyword2.setValue("待接受");
			keyword2.setColor("#173177");
			keyword3.setValue(DateUtil.convertDateToString(surveyTask.getCreateOn(),"yyyy-MM-dd HH:ss"));
			keyword3.setColor("#173177");
			remark.setValue("请尽快接受并处理！");
			remark.setColor("#173177");
			TaskData task = new TaskData();
			task.setFirst(first);
			task.setKeyword1(keyword1);
			task.setKeyword2(keyword2);
			task.setKeyword3(keyword3);
			task.setRemark(remark);
			taskNotice.setData(task);
			String sendMsg = JSONObject.fromObject(taskNotice).toString();
			AccessToken accessToken = accessTokenService.getAccessToken();
			if(WeixinUtil.sendTemplateMsg(sendMsg,accessToken)){
				System.out.println("发送OK");
			}else {
				System.out.println("发送失败");
			}
		}				
	}
	
//	@RequestMapping("getExcelForDataBase")
//	public void getExcelForDataBase(){
//		excelForActivityService.getExcelForDataBase();
//	}
//	@RequestMapping("sendTask")
//	public void sendTask(){
//		List<SurveyTask> list = surveyTaskService.findSurveyTaskListByStatus(SurveyTaskStatus.DISTRIBUTE);
//		for(SurveyTask surveyTask : list){
//			String message = surveyTask.getSurveyMan().getName()+" 勘察员，现有 " + surveyTask.getTaskCode() + " 编号勘察任务.在 "
//					+ surveyTask.getAddress() + " 地点，" + surveyTask.getCompletionTime() + " 时间内完成勘察，项目联系人:"
//					+ surveyTask.getContacts() + "，联系电话:"+surveyTask.getContactMobile();
//			
//			
//			PushMessage strMsg = new PushMessage();
//			Text text = new Text();
//			text.setContent(message);
//			strMsg.setText(text);
//			strMsg.setTouser(surveyTask.getSurveyMan().getOpenId());		
//
//			String jsonMsg = JSONObject.fromObject(strMsg).toString();
//	        AccessToken accessToken = accessTokenService.getAccessToken();
//			if(WeixinUtil.sendCustomMsg(jsonMsg,accessToken)){
//				System.out.println("发送OK");
//			}else
//				System.out.println("发送失败");
//		}		
//	}
}
