package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.*;
import com.bcxin.survey.enums.report.*;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.wechat.*;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.vo.DwzPage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping("/wechat/question")
public class WechatQuestionController extends BaseController {

	@Autowired
	private UserService userService;
	
	@Autowired
	private SurveyTaskService surveyTaskService;
		
	@Autowired
	private SurveyFeedBackService surveyFeedBackService;
	
	@Autowired
	private SurveyInfoService surveyInfoService;
	
	@Autowired
	private SurveyPhotoService surveyPhotoService;
	
	@Autowired
	private SurveyAssistService surveyAssistService;	
	
	@Autowired
	private SurveyQuestionnaireService surveyQuestionnaireService;
	
	@Autowired
	private SurveyTagService surveyTagService;

	@Autowired
	private AccessTokenService accessTokenService;

	@Autowired
	private SurveyPlanService surveyPlanService;
	
	/**
	 * 勘查问卷
	 * @param request
	 * @return
	 */
	@RequestMapping("/init")
	public ModelAndView index(HttpServletRequest request,DwzPage page){
		ModelAndView view = new ModelAndView("wechat/question/taskList");	
		page.setNumPerPage(10);
		User user = (User) userService.getCurrentUser();
		if(user != null ){			
			view.addObject("user", user);
//			List<SurveyTask> taskList = surveyTaskService.findUnFinishedSurveyTaskListByUserForPage(user,page);
			List<SurveyTask> taskList = surveyTaskService.findSurveyTaskListByUserAndStatusForPage(user, null, SurveyTaskStatus.ALL,page);
			view.addObject("taskList",taskList);
		}
		return view;
	}

	/**
	 * 分页查询问卷项目列表
	 * @param request
	 * @param page
	 * @return
	 */
	@RequestMapping("gettaskListForPage")
	public ModelAndView gettaskListForPage(HttpServletRequest request,DwzPage page){
		ModelAndView view = new ModelAndView("wechat/question/taskList_table");
		User user = (User) userService.getCurrentUser();
		if(user != null ){				  
//			List<SurveyTask> taskList = surveyTaskService.findUnFinishedSurveyTaskListByUserForPage(user,page);
			List<SurveyTask> taskList = surveyTaskService.findSurveyTaskListByUserAndStatusForPage(user, null, SurveyTaskStatus.ALL,page);
			view.addObject("taskList",taskList);
		}
		return view;
	}
	
	/**
	 * 根据项目查询问卷列表
	 * @param taskId
	 * @return
	 */
	@RequestMapping("questionList/init/{taskId}")
	public ModelAndView questionListInit(@PathVariable long taskId){
		ModelAndView view = new ModelAndView("wechat/question/questionList");	
		User user = (User) userService.getCurrentUser();
		view.addObject("user", user);
		view.addObject("surveyTask",surveyTaskService.findSurveyTaskByOid(taskId));
		view.addObject("planList",surveyPlanService.findSurveyPlanByTaskId(taskId));
		return view;
	}
	
	/**
	 * 维护问卷 页面初始化
	 * @param planId
	 * @param request
	 * @return
	 */
	@RequestMapping("editQuestion/{planId}")
	public  ModelAndView editQuestion(@PathVariable long planId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/question/editQuestion");
		User user = (User) userService.getCurrentUser();
		if(user != null ){		
			view.addObject("user", user);	  
			SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
			Survey_Questionnaire questionnaire = surveyPlan.getQuestionnaire();
			boolean lastSurveyComplete = true;
			int thisStep = Integer.parseInt(questionnaire.getSurveyStep().getValue());
			if(thisStep > 1){
				Survey_FeedBack feedBack= surveyFeedBackService.findSurveyFeedBackByTaskAndStep(questionnaire.getFeedBack().getSurveyTask(), SurveyStep.convertValue((thisStep-1)+""));
				if(!feedBack.getTaskStatus().equals(FeedBackStatusEnum.COMPLETE)) {
					lastSurveyComplete = false;
				}
			}
			view.addObject("lastSurveyComplete",lastSurveyComplete);
			view.addObject("surveyPlan",surveyPlan);
			if(lastSurveyComplete){
				view.addObject("questionnaire",questionnaire);
				Activity activity = surveyPlan.getSurveyTask().getActivity();
				String addressType = "";
				String activityType = "";
				if (activity != null) {
					addressType = activity.getAddressType();
				}
				if (activity != null) {
					activityType = activity.getActivityType();
				}
				List<Survey_Info> surveyInfoList= surveyInfoService.getSurveyInfoFormCMSForFix(questionnaire.getSurveyStep(),activityType,addressType);
				view.addObject("surveyInfoList", surveyInfoList);
				
//				accessTokenService.getJsApiConfig(view, request);
			}
		}
		return view;
	}

	/**
	 * 修改问卷
	 * @param questionnaireId
	 * @return
	 */
	/*@RequestMapping("editQuestion/{planId}")
	public  ModelAndView editQuestion(@PathVariable long planId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/question/editQuestion");
		User user = (User) authService.getCurrentUser();
		view.addObject("user", user);
		SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
		Survey_Questionnaire questionnaire = surveyPlan.getQuestionnaire();
		List<Survey_Info> surveyInfoList= surveyInfoService.getSurveyInfoFormCMSForFix(questionnaire.getSurveyStep());
		view.addObject("surveyPlan",surveyPlan);
		view.addObject("questionnaire",questionnaire);
		view.addObject("surveyInfoList", surveyInfoList);
		view.addObject("surveyStep", questionnaire.getFeedBack().getSurveyStep());
		view.addObject("tagList",surveyTagService.findSurveyTagListByTypeAndLevel(TagType.LABEL,1));//标签
		
		String jsapi_ticket= accessTokenService.getJsapiTicket();
		String url = GlobalResources.WEB_URL+request.getServletPath();
		System.out.println(request.getQueryString());
		if(StringUtil.isNotEmpty(request.getQueryString()))
			url = url + "?"+ request.getQueryString();

		System.out.println(url);
		String noncestr = StringUtil.randomString(16);
		String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
		String sign = WeixinUtil.getJSSDKSign(jsapi_ticket, noncestr, timestamp, url);
		view.addObject("appid",GlobalResources.APPID);
		view.addObject("url",url);
		view.addObject("noncestr",noncestr);
		view.addObject("timestamp",timestamp);
		view.addObject("sign",sign);
		return view;
	}*/
	/**
	 *  查询遗留及开放问题
	 * @param questionnaireId
	 * @return
	 */
	@RequestMapping("queryOptionalQuestion")
	public ModelAndView queryOptionalQuestion(long questionnaireId){
		ModelAndView view= new ModelAndView("wechat/question/optionalQusDetail");
		Survey_Questionnaire questionnaire = surveyQuestionnaireService.findQuestionnaireByOid(questionnaireId);
		view.addObject("questionnaire",questionnaire);
		view.addObject("tagList",surveyTagService.findSurveyTagListByTypeAndLevel(TagType.LABEL,1));//标签
		if(!questionnaire.getSurveyStep().equals(SurveyStep.FIRST)){
			SurveyStep lastStep = SurveyStep.convertValue(Integer.parseInt(questionnaire.getSurveyStep().getValue())-1+"");
			Survey_FeedBack surveyFeedBack = surveyFeedBackService.findSurveyFeedBackByTaskAndStep(questionnaire.getFeedBack().getSurveyTask(), lastStep);
			Survey_Questionnaire surveyQuestionnaire = surveyQuestionnaireService.findQuestionnaireByFeedBackIdAndAddressId(surveyFeedBack.getOid(), questionnaire.getVenue().getOid());
			
			List<Survey_Info> survey_Infos = surveyInfoService.findSurveyInfosByQuestionTypeAndQuestionnaireId(null, surveyQuestionnaire.getOid());
			view.addObject("surveyInfos",survey_Infos);
		}
		return view;
	}
	
	/**
	 * 查询下级标签
	 * @param tagId
	 * @return
	 */
	@RequestMapping("findTagsByTagId")
	public ModelAndView findTagsByTagId(long tagId){
		ModelAndView view= new ModelAndView("wechat/question/subTag");
		List<SurveyTag> tagList = surveyTagService.findSurveyTagListByParentId(tagId);
		view.addObject("tagList",tagList);
		view.addObject("tag",surveyTagService.findSurveyTagByOid(tagId));
		return view;
	}
	
	/**
	 * 通过标签从CMS查询勘查问题
	 * @param tags
	 * @return
	 */
	@RequestMapping("findQuestionFromCMSByTags")
	public JSONObject findQuestionFromCMSByTags(String tags){
		JSONObject json = new JSONObject();
		JSONArray questions = new  JSONArray();
		String status = "300";
		List<Survey_Info> infos= surveyInfoService.findSurveyInfoFromCMSByTags(tags);
		if(infos.size() > 0) {
			status = "200";
		}
		for (Survey_Info survey_Info : infos) {
			JSONObject info = new JSONObject();
			info.put("aid", survey_Info.getAid());
			info.put("question", survey_Info.getQuestion());
			questions.add(info);
		}
		json.put("status", status);
		json.put("infos", questions);
		return json;
	}
	
	/**
	 * 添加补充问题
	 * @param questionnaireId
	 * @param question
	 * @return
	 */
	@RequestMapping("/addQuestion")
	public JSONObject addQuestion(long questionnaireId,String question, int questionSize){
		String message = "";
		String status = "300";
		JSONObject json = new JSONObject();
//		User user = (User) authService.getCurrentUser();
		Survey_Questionnaire questionnaire = surveyQuestionnaireService.findQuestionnaireByOid(questionnaireId);
		questionSize++;
		Survey_Info surveyQuestion = new Survey_Info();
		surveyQuestion.setCreateOn(new Date());
		surveyQuestion.setQuestionnaire(questionnaire);
		surveyQuestion.setQuestion(question);
		surveyQuestion.setQuestionType(QuestionType.SUPPLEMENT);
		surveyQuestion.setSort(questionSize);
		if(surveyInfoService.saveOrUpdate(surveyQuestion)){
			message = "添加成功！";
			status="200";
			json.put("oid",surveyQuestion.getOid());
			json.put("question",surveyQuestion.getQuestion());
		}else{
			message = "添加失败！";
			status="300";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}
	
	/**
	 * 添加可选问题
	 * @param questionnaireId
	 * @param aids
	 * @return
	 */
	@RequestMapping("addOptionalQuestion")
	public JSONObject addOptionalQuestion(String aids,long questionnaireId,int questionSize){
		String message = "";
		String status = "300";
		JSONObject json = new JSONObject();
		Survey_Questionnaire questionnaire = surveyQuestionnaireService.findQuestionnaireByOid(questionnaireId);
		
		if(StringUtil.isNotEmpty(aids)){
			for(String aid:aids.split("#")){
				Survey_Info info = surveyInfoService.findSurveyInfoByaidAndQuestionType(aid, questionnaire.getOid(),QuestionType.UNFIXED);
				if(info != null) {
					message = message + "'" + info.getQuestion() + "'此开放问题已存在！\r\n";
				}else{
					questionSize ++;
					info = surveyInfoService.findSurveyInfoByaidFormCMS(aid);
					info.setQuestionnaire(questionnaire);
					info.setSort(questionSize);
					info.setQuestionType(QuestionType.UNFIXED);
					surveyInfoService.saveOrUpdate(info);
				}
			}
		}
		if(StringUtil.isEmpty(message)){
			status = "200";
			message="添加成功！";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}
	
	
	/**
	 * 刷新开放补充问题列表
	 * @param planId
	 * @return
	 */
	@RequestMapping("reSetQuestionList")
	public JSONObject reSetQuestionList(long planId){
		JSONObject json = new JSONObject();
		JSONArray arr= new JSONArray();
		SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
		Survey_Questionnaire questionnaire = surveyPlan.getQuestionnaire();
		int i=1;
		for(Survey_Info surveyInfo : questionnaire.getSurveyInfos()){
			if(surveyInfo.getQuestionType() == null) {
				continue;
			}
			if(surveyInfo.getQuestionType().equals(QuestionType.UNFIXED) || surveyInfo.getQuestionType().equals(QuestionType.SUPPLEMENT)) {
				JSONObject obj = new JSONObject();
				obj.put("oid", surveyInfo.getOid());
				obj.put("question", surveyInfo.getQuestion());
				obj.put("questionSize", i++);

				obj.put("questionType", surveyInfo.getQuestionType());
				obj.put("questionTypeName", surveyInfo.getQuestionType().getName());
				arr.add(obj);
			}
		}
		json.put("questionList", arr);
		return json;
	}
	
	/**
	 * 删除问题
	 * @param quesId
	 * @return
	 */
	@RequestMapping("/removeQuestion")
	public JSONObject removeQuestion(long quesId){
		String message = "";
		String status = "300";
		JSONObject json = new JSONObject();
		Survey_Info surveyQuestion = surveyInfoService.findSurveyInfoByOid(quesId);
		if(surveyInfoService.delete(surveyQuestion)){
			message = "删除成功！";
			status="200";
		}else{
			message = "删除失败！";
			status="300";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}
	
	/**
	 * 维护勘查问卷 业务处理
	 * @param questionnaireId
	 * @param request
	 * @return
	 */

	@RequestMapping("/createQuestion")
	public JSONObject createQuestion(long questionnaireId,HttpServletRequest request) {
		User user = userService.getCurrentUser();
		return surveyFeedBackService.createQuestion(user,questionnaireId,request);
	}

	/**
	 * 预览生成的勘查问卷
	 * @param planId
	 * @param request
	 * @return
	 */
	@RequestMapping("viewQuestion")
	public ModelAndView viewQuestion(long planId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/question/viewQuestion");
		SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
		List<Survey_Info> infos = surveyPlan.getQuestionnaire().getSurveyInfos();
		for (Survey_Info survey_Info : infos) {
			if(StringUtil.isNotEmpty(survey_Info.getLastSurveyInfoId())) {
				survey_Info.setLastSurvey(surveyInfoService.findSurveyInfoByOid(Long.parseLong(survey_Info.getLastSurveyInfoId())));
			}
		}
		view.addObject("questionnaire",surveyPlan.getQuestionnaire());
		view.addObject("surveyPlan",surveyPlan);
		view.addObject("surveyInfos",infos);
		
//		accessTokenService.getJsApiConfig(view, request);
		
		return view;
	}
	
	
}
