package com.bcxin.survey.controller.manage;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.dto.TableResult;
import com.bcxin.survey.dto.TaskSearchDto;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.manage.TaskManageService;
import com.bcxin.survey.service.report.TaskService;
import com.bcxin.survey.utils.DictConst;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.vo.DwzPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@Controller
@RequestMapping("manage/task")
public class TaskManageController extends BaseController {

	@Autowired
	private TaskManageService taskManageService;
	
	@Autowired
	private TaskService taskService;

	@Autowired
	private UserService userService;
	
	@RequestMapping("taskList/init")
	public ModelAndView taskListInit(){
		ModelAndView view = new ModelAndView("manage/task/taskList");
		return view;
	}
	
	@RequestMapping("findTaskListForPage")
	@ResponseBody
	public TableResult findTaskListForPage(TaskSearchDto searchDto,DwzPage page){
		User user = userService.getCurrentUser();
		TableResult result = new TableResult();
		searchDto.setUserid(user.getOid());
		result.setRows(taskManageService.findSurveyTaskListForPage(searchDto,page));
		result.setTotal(page.getTotalCount());
		return result;
	}
	
	@RequestMapping("/distributeTask/{oid}")
	public ModelAndView distributeTaskByOid(@PathVariable Long oid){
		ModelAndView view = new ModelAndView("manage/task/distributeTask");
		User currentUser = userService.getCurrentUser();
		Task task = taskService.findTaskByOid(oid);		
		view.addObject("task", task);
		view.addObject("assginList", userService.findUserListByOrgIdAndUserType(currentUser.getOrg().getOid(),DictConst.USERTYPE_CM));
		return view;
	}
	
	@RequestMapping("/distributeTask")
	public Map<String,String> distributeTask(HttpServletRequest request) throws Exception{
		String assgin = request.getParameter("assgin");
		String oid = request.getParameter("oid");
		if ( StringUtil.isNotEmpty(assgin) && StringUtil.isNotEmpty(oid)) {
			return taskManageService.distributeTask(oid,assgin);
		}
		return null;
	}
	
}
