package com.bcxin.survey.controller.manage;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.domain.survey.Survey_Photo;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.dto.AjaxResult;
import com.bcxin.survey.dto.SurveyReportSearchDto;
import com.bcxin.survey.dto.TableResult;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.manage.SurveyReportManageService;
import com.bcxin.survey.service.wechat.SurveyInfoService;
import com.bcxin.survey.service.wechat.SurveyPhotoService;
import com.bcxin.survey.service.wechat.SurveyQuestionnaireService;
import com.bcxin.survey.utils.DWZUtil;
import com.bcxin.survey.utils.Tips_CN;
import com.bcxin.survey.vo.DwzPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 勘查报告管理
 * Created by Administrator on 2018/07/20 0020.
 */
@Controller
@RequestMapping("/manage/surveyReport")
public class SurveyReportManageController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private SurveyReportManageService surveyReportManageService;

    @Autowired
    private SurveyQuestionnaireService surveyQuestionnaireService;

    @Autowired
    private SurveyInfoService surveyInfoService;

    @Autowired
    private SurveyPhotoService surveyPhotoService;

    @RequestMapping("reportList/init")
    public ModelAndView reportList(){
        ModelAndView view = new ModelAndView("manage/surveyReport/reportList");
        return view;
    }

    @RequestMapping("findReportListForPage")
    @ResponseBody
    public TableResult findReportListForPage(SurveyReportSearchDto searchDto, DwzPage page){

        User user = userService.getCurrentUser();
        TableResult result = new TableResult();
        searchDto.setUserid(user.getOid());
        result.setRows(surveyReportManageService.findReportListForPage(searchDto,page));
        result.setTotal(page.getTotalCount());
        return result;
    }

    @RequestMapping("/reportDetail/{oid}")
    public ModelAndView reportDetail(@PathVariable Long oid){
        ModelAndView view = new ModelAndView("manage/surveyReport/reportDetail");
        Survey_Questionnaire questionnaire =surveyQuestionnaireService.findQuestionnaireByOid(oid);
        List<Survey_Info> infos = questionnaire.getSurveyInfos();
        view.addObject("questionnaire",questionnaire);
        view.addObject("surveyInfoList",infos);
        return view;


    }

    @RequestMapping("/reCreateSurveyReport/{oid}")
    public Map<String,String> reCreateSurveyReport(@PathVariable Long oid,HttpServletRequest request) throws Exception{
        try {
            Survey_Questionnaire survey_Questionnaire = surveyQuestionnaireService.findQuestionnaireByOid(oid);
            surveyQuestionnaireService.createSurveyReport(survey_Questionnaire,null);
            return DWZUtil.returnSuccessJson(Tips_CN.OP_SUCCEED, "reportList","closeCurrent", "surveyReport/reportList/init");
        }catch (Exception e){
            return DWZUtil.returnFailedJson(Tips_CN.OP_FAILURE, "reportList", "closeCurrent", "");

        }
    }

    @RequestMapping("/removeImg")
    public @ResponseBody AjaxResult removeImg(Survey_Photo photo, HttpServletRequest request) throws Exception{
        AjaxResult result = new AjaxResult();
        result.setSuccessful(surveyPhotoService.delete(photo));
        return result;
    }
}
