package com.bcxin.survey.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

import org.springframework.util.StringUtils;


public class ObjectSeriUtils {
	
	public static String in(Serializable obj) throws IOException{
		ByteArrayOutputStream buffer = new ByteArrayOutputStream();
		ObjectOutputStream objStream = new ObjectOutputStream(buffer);
		objStream.writeObject(obj);
		objStream.flush();
		String result = new String(Base64.getEncoder().encode(buffer.toByteArray()),"UTF-8");
		objStream.close();
		return result;
	}
	
	public static Object out(String objStr) throws IOException, ClassNotFoundException{
		if ( StringUtils.isEmpty(objStr) ) {
			return null;
		}
		byte[] decode = Base64.getDecoder().decode(objStr);
		ObjectInputStream objStream = new ObjectInputStream(new ByteArrayInputStream(decode));
		Object obj = objStream.readObject();
		objStream.close();
		return obj;
	}
	
	public static byte [] toByte(Serializable obj) throws IOException{
		ByteArrayOutputStream buffer = new ByteArrayOutputStream();
		ObjectOutputStream objStream = new ObjectOutputStream(buffer);
		objStream.writeObject(obj);
		objStream.flush();
		byte [] result = buffer.toByteArray();
		buffer.close();
		objStream.close();
		return result;
	}
	
	public static Object toObject(byte [] array) throws Exception{
		ObjectInputStream objStream = new ObjectInputStream(new ByteArrayInputStream(array));
		Object obj = objStream.readObject();
		objStream.close();
		return obj;
	}
	

}
