package com.bcxin.survey.utils;


import com.google.common.base.Stopwatch;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import javax.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpUtil {

	public static void requestHttp(String invokeType) {
		String url = Const.BLANK_CHAR;
		if ( "1".equals(invokeType) ) {
			url = GlobalResources.WEB_URL;
		}
		try {
			HttpClient httpclient = new HttpClient();
			PostMethod postMethod = new PostMethod(url);
			httpclient.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "GBK");
			httpclient.executeMethod(postMethod);
			postMethod.getResponseBodyAsString();
			postMethod.releaseConnection();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	

	/**
	 * 获取请求参数中所有的信息
	 * @param request
	 * @return
	 */
	public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
		Map<String, String> res = new HashMap<String, String>();
		Enumeration<?> temp = request.getParameterNames();
		if (null != temp) {
			while (temp.hasMoreElements()) {
				String en = (String) temp.nextElement();
				String value = request.getParameter(en);
				res.put(en, value);
				//在报文上送时，如果字段的值为空，则不上送<下面的处理为在获取所有参数数据时，判断若值为空，则删除这个字段>
				//System.out.println("ServletUtil类247行  temp数据的键=="+en+"     值==="+value);
				if (null == res.get(en) || "".equals(res.get(en))) {
					res.remove(en);
				}
			}
		}
		return res;
	}


	/**
	 * POST方式调用
	 * @author luopeng
	 * @param url
	 * @param params
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 * @throws java.io.UnsupportedEncodingException
	 */
	public static String sendPostRequest(String url, List<NameValuePair> params) {
		System.out.println("--------开始发送http请求--------");
		System.out.println("请求地址:[{"+url+"}]：");
		Stopwatch stopwatch = Stopwatch.createStarted();
		String result = "";
		try {
			CloseableHttpClient httpClient = HttpClients.createDefault();
			HttpPost httpPost = new HttpPost(url);
			httpPost.setEntity(new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
			RequestConfig defaultRequestConfig = RequestConfig.custom()
					.setSocketTimeout(60000)
					.setConnectTimeout(60000)
					.setConnectionRequestTimeout(60000)
					.build();
			httpPost.setConfig(defaultRequestConfig);
			CloseableHttpResponse resp = httpClient.execute(httpPost);
			HttpEntity entity = resp.getEntity();
			result = EntityUtils.toString(entity,StandardCharsets.UTF_8);
			long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
			System.out.println("返回结果：[{"+result+"}]");
			System.out.println("共耗时[{"+nanos+"}]毫秒：");
			System.out.println("--------结束http请求--------");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return result;
	}
}
