package com.bcxin.survey.utils;

import com.alibaba.fastjson.JSON;
import com.bcxin.survey.dao.dynamic.DynamicPanelDao;
import com.bcxin.survey.dao.dynamic.DynamicPanelTemplateDao;
import com.bcxin.survey.dao.report.ActivityCooperDao;
import com.bcxin.survey.dao.report.SurveyExpertDao;
import com.bcxin.survey.dao.report.TaskDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.dynamic.DynamicPanel;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.Org;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.dto.ActivityCooperDTO;
import com.bcxin.survey.dto.DynamicSurveyPanel;
import com.bcxin.survey.enums.dynamic.DynamicPermissionEnum;
import com.bcxin.survey.enums.dynamic.DynamicTypeEnum;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.service.wechat.SurveyQuestionnaireService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author hzp
 * 动态看板工具类
 * 采用异步调用方式
 */
@Service("dynamicUtil")
@Transactional
@Slf4j
public class DynamicUtil {

    @Resource
    private DynamicPanelDao dynamicPanelDao;
    @Resource
    private DynamicPanelTemplateDao dynamicPanelTemplateDao;
    @Resource
    private TaskDao taskDao;
    @Resource
    private ActivityCooperDao activityCooperDao;
    @Resource
    private SurveyExpertDao surveyExpertDao;
    @Resource
    private SurveyQuestionnaireService surveyQuestionnaireService;
    @Resource
    private ActivityService activityService;

    /**
     * 获取容器
     * @return
     */
    public static DynamicUtil getBean(){
        DynamicUtil dynamicUtil=(DynamicUtil)SpringContextUtil.getBean("dynamicUtil");
        return dynamicUtil;
    }

    /****************************************踏勘*******************************************/
    @Async
    public void saveTKData(User operateUser, Long templateId, Long taskId){
        saveTKData(operateUser,templateId,taskId,DynamicPermissionEnum.DYNAMIC_ALL);
    }

    @Async
    public void saveTKData(User operateUser,Long templateId,Task task){
        saveTKData(operateUser,templateId,task,DynamicPermissionEnum.DYNAMIC_ALL);
    }

    @Async
    public void saveTKData(User operateUser,Long templateId,Long taskId,DynamicPermissionEnum permissionEnum){
        Task task=taskDao.findTaskByOid(taskId);
        saveTKData(operateUser,templateId,task,permissionEnum);
    }

    /**
     * 踏勘计划
     * @param operateUser
     * @param templateId
     * @param activityId
     * @param step
     * @param surveyTime
     * @param venueName
     */
    @Async
    public void saveTKPlanData(User operateUser,Long templateId,Long activityId,String step,String surveyTime,String venueName){
        Activity activity=activityService.findActivityByOid(activityId);
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId=getPingGuOrg(orgList);
        Long contractId=activity.getOrg().getOid();

        DynamicPanel panel=new DynamicPanel();

        DynamicPermissionEnum permissionEnum=DynamicPermissionEnum.DYNAMIC_ALL;
        panel.setOrgId(orgId);
        panel.setContractOrgId(contractId);
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        DynamicSurveyPanel surveyPanel=new DynamicSurveyPanel(operateUser,activity,step,surveyTime,venueName);
        panel.setTemplateData(JSON.toJSONString(surveyPanel));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    @Async
    public void saveTKReportData(User operateUser,Long templateId,Activity activity,String step,String surveyReport,Long questionnaireId){
        Survey_Questionnaire questionnaire=surveyQuestionnaireService.findQuestionnaireByOid(questionnaireId);
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId=getPingGuOrg(orgList);
        Long contractId=activity.getOrg().getOid();

        // 踏勘整改意见
        List<Survey_Info> surveyInfoList=questionnaire.getSurveyInfos();

        DynamicPanel panel=new DynamicPanel();

        DynamicPermissionEnum permissionEnum=DynamicPermissionEnum.DYNAMIC_ALL;
        panel.setOrgId(orgId);
        panel.setContractOrgId(contractId);
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        DynamicSurveyPanel surveyPanel = new DynamicSurveyPanel(operateUser,activity,step,surveyReport,questionnaireId,surveyInfoList);
        panel.setTemplateData(JSON.toJSONString(surveyPanel));
        dynamicPanelDao.saveOrUpdate(panel);
    }

    @Async
    public void saveTKData(User operateUser,Long templateId,Task task,DynamicPermissionEnum permissionEnum){
        Activity activity=task.getActivity();
        String tkzjUserList=surveyExpertDao.findSurveyExperts(task.getOid());
        List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId=getPingGuOrg(orgList);
        Long contractId=activity.getOrg().getOid();

        DynamicPanel panel=new DynamicPanel();

        if(permissionEnum==null){
            permissionEnum=DynamicPermissionEnum.DYNAMIC_ALL;
        }
        if(permissionEnum==DynamicPermissionEnum.DYNAMIC_CONTRACTOR){
            panel.setContractOrgId(contractId);
        }else if(permissionEnum==DynamicPermissionEnum.DYNAMIC_FENGPING){
            panel.setOrgId(orgId);
        }else{
            panel.setContractOrgId(contractId);
            panel.setOrgId(orgId);
        }

        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if(operateUser!=null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate(dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString(new DynamicSurveyPanel(operateUser,task,tkzjUserList)));
        dynamicPanelDao.saveOrUpdate(panel);
    }



    /**
     * 获取评估机构
     * @param orgList
     * @return
     */
    public Long getPingGuOrg(List<ActivityCooperDTO> orgList){
        if(orgList!=null){
            for(ActivityCooperDTO dto : orgList){
                if(Objects.equals(dto.getServiceOrgType(),DictConst.SERVICEORGTYPE_FXPGJG)){
                    return Long.parseLong(dto.getOid());
                }
            }
        }
        return null;
    }

    /**
     * 获取风评机构
     * @param orgList
     * @return
     */
    public Org getPGOrg(List<ActivityCooperDTO> orgList){
        Org org=new Org();
        if(orgList!=null){
            for(ActivityCooperDTO dto : orgList){
                if(Objects.equals(dto.getServiceOrgType(),DictConst.SERVICEORGTYPE_FXPGJG)){
                    org.setOid(Long.parseLong(dto.getOid()));
                    org.setName(dto.getName());
                    return org;
                }
            }
        }
        return null;
    }

    /**
     * 根据模板id获取对应的类型
     * @param templateId
     * @return
     */
    private DynamicTypeEnum getDynamicType(Long templateId){
        String key=templateId.toString().substring(0,3);
        for(DynamicTypeEnum typeEnum : DynamicTypeEnum.values()){
            if(typeEnum.getKey().equals(key)){
                return typeEnum;
            }
        }
        return null;
    }

}
