package com.bcxin.survey.service.security;


import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.utils.DictConst;
import com.bcxin.survey.utils.StringUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.HashSet;

/**
 * Spring Security
 * 一个自定义的service用来和数据库进行操作,即以后我们要通过数据库保存权限。则需要我们继承UserDetailsService
 */
@Service
public class UserDetailsServiceImpl implements UserDetailsService {
	
	@Resource
	private UserService userService;

	public UserDetails loadUserByPerId(String perId) throws UsernameNotFoundException, DataAccessException {
		User user = userService.selectUserByPerId(perId);
		return getUserFacet(user.getUserName(), user);
	}
	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
		User user = userService.findUserByName(username);
		return getUserFacet(username, user);
	}

	private UserFacet getUserFacet(String username, User user) {
		if ( user == null ) {
			 throw new UsernameNotFoundException("用户" + username + "不存在!");
		}

		if (StringUtil.isEmpty(user.getActive()) || user.getActive().equals(DictConst.N)) {
            throw new UsernameNotFoundException("用户" + username + "已失效!");
        }
		//TODO 嵌套百保盾APP改造 1
        /* 限制部分人员才能登陆踏勘系统 */
        /* 踏勘人员，管理员， */
		/*if (!(DictConst.USERTYPE_CM.equals(user.getUserType())
				|| DictConst.USERTYPE_GLJGYH.equals(user.getUserType())
				|| DictConst.USERTYPE_DSFFWJGYH_TKJL.equals(user.getUserType()))) {
			throw new UsernameNotFoundException("用户限制登陆！");
		}*/
		if (!DictConst.USERTYPE_ZG.equals(user.getUserType())
				|| DictConst.USERTYPE_GLJGYH.equals(user.getUserType())
				|| DictConst.USERTYPE_DSFFWJGYH_TKJL.equals(user.getUserType())) {
			throw new UsernameNotFoundException("用户限制登陆！");
		}
		// 构造UserDetails
		return new UserFacet(username, user.getPassword(), true, true, true, true, getAuthorities(user)).subject(user);
	}

	/**
	 * 获得访问角色权限
	 * @param user
	 */
	private Collection<GrantedAuthority> getAuthorities(User user) {
		Collection<GrantedAuthority> grantedAuthority = new HashSet<GrantedAuthority>();
		//后台用户
		if ( user.getUserType().equals(DictConst.USERTYPE_GLJGYH)){
			SimpleGrantedAuthority admin = new SimpleGrantedAuthority("ROLE_ADMIN");
			grantedAuthority.add(admin);
		} else {
			//普通用户 权限
			SimpleGrantedAuthority grantedUser = new SimpleGrantedAuthority("ROLE_USER");
			grantedAuthority.add(grantedUser);
			if ( user.getUserType().equals(DictConst.USERTYPE_PM)){
				//勘查项目经理
				SimpleGrantedAuthority pmUser = new SimpleGrantedAuthority("PM");
				grantedAuthority.add(pmUser);
			}
			//TODO 嵌套百保盾APP改造 2
			if ( DictConst.USERTYPE_CM.equals(user.getUserType())||DictConst.USERTYPE_ZG.equals(user.getUserType())){
				/* 勘查人员 */
				SimpleGrantedAuthority cmUser = new SimpleGrantedAuthority("CM");
				grantedAuthority.add(cmUser);
			}
		}
		return grantedAuthority;
	}

}
