package com.bcxin.survey.service;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.survey.dao.log.SMSLogDao;
import com.bcxin.survey.domain.log.SMSLog;
import com.bcxin.survey.utils.DictConst;
import com.bcxin.survey.utils.EmailUtil;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.utils.sms.HuaWeiSmsContent;
import com.bcxin.survey.utils.sms.SMSUtil;
import com.bcxin.survey.vo.EmailModel;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.concurrent.Future;

/**
 * 发送通知service
 * 
 * @author aluo
 *
 */
@Service
@Transactional
public class NotifyServiceImpl implements NotifyService {

	/**
	 * 有效手机号长度
	 */
	private final static int VALIDATE_PHONE_LENGTH = 11;

	@Resource
	private SMSLogDao smsLogDao;

	@Resource
	private SMSUtil smsUtil;

	/**
	 * 发送短信服务
	 * <b>Function </b>
	 *
	 * @param phone
	 * @param params
	 * @author LuoPeng
	 * @date 2019年06月04日 下午1:09:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void sendHuaWeiSMS(String phone,String content,String platform,String smsCode, String[] params) {
		if (StringUtil.isEmpty(phone)) {
			return ;
		}
		if (phone.length() != VALIDATE_PHONE_LENGTH) {
			return ;
		}
		if (!StringUtil.isInteger(phone)) {
			return ;
		}
		HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
		huaWeiSmsContent.setPlatform(platform);
		huaWeiSmsContent.setSmsCode(smsCode);
		huaWeiSmsContent.setMobile(phone);
		huaWeiSmsContent.setParams(JSON.toJSONString(params));
		Future<Boolean> result = smsUtil.sendHuaWeiSMS(huaWeiSmsContent);
		content = StrUtil.format(content,params);
		try {
			if (result.get()) {
				smsInstance(phone, content, DictConst.Y);
			} else {
				smsInstance(phone, content, DictConst.N);
			}
		} catch (Exception e) {
			System.out.println("短信日志记录失败，手机号：{"+phone+"}，短信内容：{"+content+"}" );
		}
	}

	//@Override
	//public boolean sendMessage(MessageModel model){
	//	if (model == null) {
	//		return false;
	//	}
	//	if (StringUtil.isEmpty(model.getTo())) {
	//		return false;
	//	}
	//	if (model.getTo().length() != VALIDATE_PHONE_LENGTH) {
	//		return false;
	//	}
	//	if (!StringUtil.isInteger(model.getTo())) {
	//		return false;
	//	}
	//	Future<Boolean> result = SMSUtil.sendSMS(model.getTo(), model.getContent());
	//	try {
	//		if (result.get()) {
	//			smsInstance(model.getTo(), model.getContent(), DictConst.Y);
	//		} else {
	//			smsInstance(model.getTo(), model.getContent(), DictConst.N);
	//		}
	//	} catch (Exception e) {
	//		System.out.println("短信日志记录失败，手机号：【" + model.getTo() + "】，短信内容：【" + model.getContent() + "】");
	//	}
    //
	//	return true;
	//}

	private void smsInstance(String to, String content, String status) {
		SMSLog smsLog = new SMSLog();
		smsLog.setContent(content);
		smsLog.setPhone(to);
		smsLog.setSuccess(status);
		smsLog.setCreateOn(new Date());
		smsLog.setUpdateOn(new Date());
		smsLogDao.save(smsLog);
	}

	@Override
	public void sendEmail(EmailModel model) {
		if ( StringUtil.isEmpty(model.getTo()) ) {
			return;
		}
		EmailUtil emailUtil = new EmailUtil();
		emailUtil.sendEmail(model.getSubject(), model.getContent(),model.getTo(), null);
	}

}
