package com.bcxin.survey.domain.venue;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 展厅
 * @author 070
 */
@Entity
@Table(name = "venue_exhibitionhall")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class VenueExhibitionHall extends VenueBase {


    /** 建立时间 */
    private String buildDate;

    /** 场地面积 */
    private String changdimianji;

    /** 标准展位数最大容量 */
    private String biaozhunzhanweishuzuidarongliang;

    /** 展厅（馆）高度 */
    private String zhantinggaodu;

    /** 场地限高 */
    private String changdixiangao;

    /** 展厅地面材质 */
    private String zhantingdimiancaizhi;

    /** 其他类型展厅地面材质 */
    private String qitaleixing;

    /** 地面承重 */
    private String dimianchengzhong;

    /** 货门限高 */
    private String huomenxiangao;

    /** 场馆最大负荷 */
    private String changguanzuidafuhe;

    /** 电源分布图 */
    private String dianyuanfenbutu;

    /** 供电频率 */
    private String gongdianpinlv;

    /** 供电电压 */
    private String gongdiandianya;

    /** 消防配备情况 */
    private String xiaofangpeibeiqingkuang;

    /** 场馆消防验收意见书 */
    private String changguanxiaofangyanshouyijianshu;

    /** 楼梯数量 */
    private String loutishuliang;

    /** 楼梯位置 */
    private String loutiweizhi;

    /** 电梯位置 */
    private String diantiweizhi;

    /** 自动扶梯数量 */
    private String zidongfutishuliang;

    /** 自动扶梯位置 */
    private String zidongfutiweizhi;

    /** 紧急疏散口数量 */
    private String jinjishusankoushuliang;

    /** 疏散通道位置 */
    private String shusantongdaoweizhi;

    /** 无障碍通道 */
    private String wuzhangaitongdao;

    /** 固定厕所数量 */
    private String gudingcesuoshuliang;

    /** 卫生间位置 */
    private String weishengjianweizhi;

    /** 视频监控数量 */
    private String shipinjiankongshuliang;

    /** 视频监控保障文件 */
    private String shipinjiankongbaozhangwenjian;

    /** 应急广播数量 */
    private String yingjiguangboshuliang;

    /** 应急广播保障文件 */
    private String yingjiguangbobaozhangwenjian;

    /** 应急照明数量 */
    private String yingjizhaomingshuliang;

    /** 应急照明位置 */
    private String yingjizhaomingweizhi;

    /** 应急照明保障文件 */
    private String yingjizhaomingbaozhangwenjian;

    /** 通风设施数量 */
    private String tongfengsheshishuliang;

    /** 通风设施位置 */
    private String tongfengsheshiweizhi;

    /** 通风设施保障文件 */
    private String tongfengsheshibaozhangwenjian;

    /** 出入口数量 */
    private String churukoushuliang;

    /** 出入口宽度 */
    private String churukoukuandu;

    /** 配电柜/配电箱数量 */
    private String peidianguishuliang;

    /** 喷淋系统数量 */
    private String penlinxitongshulaing;

    /** 消防水炮数量 */
    private String xiaofangshuipaoshulaing;

    /** 烟感器数量 */
    private String yanganqishulaing;

    /** 紧急疏散口宽度 */
    private String jinjishusankoukuandu;

    /** 应急供电设备 */
    private String yingjigongdianshebei;

    /** 其他消防配备情况 */
    private String qitaxiaofangpeibeiqingkuang;

    /** 视频监控覆盖率 */
    private String shipinjiankongfugailv;

    /** 应急广播覆盖率 */
    private String yingjiguangbofugailv;

    /** 出入口方位 */
    private String churukoufangwei;

    /** 喷淋系统分布区域 */
    private String penlinxitongfenbuquyu;

    /** 消防水炮分布区域 */
    private String xiaofangshuipaofenbuquyu;

    /** 烟感器分布区域 */
    private String yanganqifenbuquyu;

    /** 通讯信号器 */
    private String tongxunxinhaoqi;

    /** 监控系统可用状态 */
    private String jiankongxitongkeyongzhuangtai;

    /** 场内监控可用状态 */
    private String changneijiankongkeyongzhaungtai;

    /** 场外监控可用状态 */
    private String changwaijiankongkeyongzhaungtai;

    /** 监控指挥中心可用状态 */
    private String jiankongzhihuizhongxinkeyongzhaungtai;

    /** 应急广播 */
    private String yingjiguangbo;

    /** 应急照明 */
    private String yingjizhaoming;

    /** 应急疏散指示墙体标识 */
    private String yingjishusanzhishiqiangtibiaoshi;

    /** 应急疏散指示地标识 */
    private String yingjishusanzhishidibiaoshi;

    /** 通风设施 */
    private String tongfengsheshi;

    /** 避难场所 */
    private String binanchangsuo;

    /** 公共交通 */
    private String gonggongjiaotong;

    /** 加油站/危险品仓库 */
    private String jiayouzhan;

    /** 停车位 */
    private String tignchewe;
}