package com.bcxin.survey.domain.activity;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.data.Region;
import com.bcxin.survey.domain.security.Org;
import com.bcxin.survey.domain.security.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 活动信息表
 */
@Entity
@Table(name = "RISK_Activity")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@DynamicInsert(true)
@DynamicUpdate(true)
@Data
public class Activity extends BaseBean {


	private static final long serialVersionUID = 1L;
	
	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

	/**
	 * 省份
	 */
	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "province_id")
	private Region province;

	/**
	 * 市
	 */
	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "city_id")
	private Region city;

	/**
	 * 区
	 */
	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "area_id")
	private Region area;

	private String activityNo;
	
	private String name; //活动名称
	
	private String activityStatus;//活动状态（字典）

	private String activityType;//活动类型

    private String number;// 活动人数

    private String days;// 活动天数

    private String addressType;//活动地点（室内和室外） 字典

    private String outDoorType;//室外地点（字典）

    private String sponsor;//主办单位

    private String address; //活动地址，xxxx#xxxx

    private String startDate;// 开始时间

    private String endDate;// 结束时间

	/**
	 * 活动申请的渠道（sb_sn.dh.pss360.cn,代表申报子系统陕西环境）
	 */
	private String channel;

	@ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "org_id")
	private Org org;

}
