package com.bcxin.survey.dao.report;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.survey.dao.QueryHelper;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.dto.TaskDetailVo;
import com.bcxin.survey.dto.TaskSearchDto;
import com.bcxin.survey.enums.report.AcceptStatus;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.enums.report.TaskStatus;
import com.bcxin.survey.utils.CollectionUtil;
import com.bcxin.survey.utils.DateUtil;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.vo.DwzPage;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository("taskDao")
@SuppressWarnings("unchecked")
public class TaskDaoImpl extends BaseDaoImpl implements TaskDao {

	@Override
	public List<Task> findTaskList(User user ,DwzPage page) {
		List<Criterion> criterions = new ArrayList<Criterion>();

		if (user != null) {
			criterions.add(Restrictions.eq("user", user));
		}
		criterions.add(Restrictions.eq("taskType", "2"));
		return findByCriterionForPage(Task.class, criterions,page);
	}


	@Override
	public Task findTaskByOid(long oid) {
		return findByCriterionToUnique(Task.class, Restrictions.eq("oid", oid));
	}

	@Override
	public List<TaskDetailVo> findSurveyTaskListForPage(TaskSearchDto searchDto, DwzPage page) {
		StringBuffer sql = new StringBuffer();
		sql.append("select DISTINCT rt.oid,rt.`name`,");
		sql.append("IF(orf.orderStatus = '1','已支付','未支付') as 'reportStatus',");
		sql.append("assgin.realName as 'assgin',rt.acceptStatus,rt.taskStatus,");
		sql.append("DATE_FORMAT(rt.acceptDate,'%Y-%m-%d %H:%i:00')  as 'acceptDate',");
		sql.append("DATE_FORMAT(rt.finishDate,'%Y-%m-%d %H:%i:00')  as 'finishDate',");
		sql.append("DATE_FORMAT(rt.createOn,'%Y-%m-%d %H:%i:00')  as 'createOn'");
		sql.append(" from risk_task rt ");
		sql.append(" INNER JOIN RISK_OrderForm orf on rt.activity_id=orf.activity_id ");
		sql.append(" INNER JOIN risk_activity_cooper rac on rt.activity_id=rac.activity_id ");
		sql.append(" INNER JOIN risk_se_user rsu on rsu.org_id=rac.org_id ");
		sql.append(" LEFT JOIN risk_se_user assgin on assgin.oid=rt.assgin_id ");
		sql.append(" where  rt.taskType='2'");
		if(searchDto.getUserid() != null) {
			sql.append(" and rsu.oid = "+searchDto.getUserid());
		}
		if(page != null) {
			if (StringUtil.isNotEmpty(page.getHtml())) {
				sql.append(" name like '%" + page.getHtml() + "%'");
			}

			Integer count = this.findCountBySQL(sql.toString(),null);
			page.setTotalCount(count);
			if (StringUtil.isNotEmpty(page.getOrderField())) {
				if (StringUtil.isEmpty(page.getOrderDirection()) || page.getOrderDirection().equals("asc")) {
					sql.append(" order by " + page.getOrderField() + " asc");
				} else {
					sql.append(" order by " + page.getOrderField() + " desc");
				}
			} else {
				sql.append(" order by createOn desc");
			}

			sql.append(" limit "+page.getNumPerPage()*(page.getPageNum()-1)+","+page.getNumPerPage());
		}

		List<Map<String,Object>> list = this.findBySQL(sql.toString(),null);
		List<TaskDetailVo> result = new ArrayList<TaskDetailVo>();
		list.forEach(map->{
			TaskDetailVo taskDetailVo = BeanUtil.mapToBean(map,TaskDetailVo.class,true);
			if(StringUtil.isNotEmpty(taskDetailVo.getAcceptStatus())){
				taskDetailVo.setAcceptStatusValue(taskDetailVo.getAcceptStatus());
//				taskDetailVo.setAcceptStatus(AcceptStatus.convert(taskDetailVo.getAcceptStatus()).getName());
				taskDetailVo.setAcceptStatus(AcceptStatus.getAlias(taskDetailVo.getAcceptStatus()));
			}
			if(StringUtil.isNotEmpty(taskDetailVo.getTaskStatus())){
				taskDetailVo.setTaskStatusValue(taskDetailVo.getTaskStatus());
//				taskDetailVo.setTaskStatus(TaskStatus.convert_value(taskDetailVo.getTaskStatus()).getName());
				taskDetailVo.setTaskStatus(TaskStatus.getAlias(taskDetailVo.getTaskStatus()));
			}
			result.add(taskDetailVo);
		});
		return result;
	}

	@Override
	public List<TaskDetailVo> findTaskListByOvertime3Hour(Long orgId) {
		StringBuffer sql = new StringBuffer();
		sql.append("select DISTINCT rt.oid,rt.`name`,IFNULL(assgin.realName,assgin.userName) as 'assgin'");
		sql.append(" from risk_task rt ");
		sql.append(" INNER JOIN risk_activity_cooper rac on rt.activity_id=rac.activity_id ");
		sql.append(" INNER JOIN risk_se_user assgin on assgin.oid=rt.assgin_id ");
		sql.append(" where  rt.taskType='2'");
		sql.append(" and  rt.acceptStatus='0'");
		sql.append(" and  rt.taskStatus='5'");

		try {
			String now = DateUtil.dateAdd(4, DateUtil.getCurrentDate("yyyy-MM-dd HH:mm:ss"), -3);
			sql.append(" and  rt.updateOn < '"+now+"'");
		} catch (Exception e) {
			e.printStackTrace();
		}

		List<Map<String,Object>> list = this.findBySQL(sql.toString(),null);
		List<TaskDetailVo> result = new ArrayList<TaskDetailVo>();
		list.forEach(map->{
			TaskDetailVo taskDetailVo = BeanUtil.mapToBean(map,TaskDetailVo.class,true);
			result.add(taskDetailVo);
		});
		return result;
	}

	@Override
	public List<Task> selectTaskBysurveryTaskId(Long oid) {
		List<Task> taskList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("select b.* FROM risk_surveytask a INNER JOIN risk_task b ON a.taskId = b.oid WHERE a.oid = " + oid);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if (CollectionUtil.isNotEmpty(list)) {
			list.forEach(obj -> {
				Map<String, Object> map = (HashMap<String, Object>) obj;
				Task task = BeanUtil.mapToBean(map, Task.class, true);
				taskList.add(task);
			});
		}
		return taskList;
	}

	/**
	 * 查询专家信息
	 *
	 * @param taskId
	 * @return
	 * @Author 张建华
	 */
	@Override
	public User selectExpertBySurveyTaskId(long taskId) {
		List<User> userList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("SELECT b.* FROM risk_task a INNER JOIN risk_se_user b ");
		sql.append("ON a.expert_id = b.oid  INNER JOIN risk_surveytask c  ");
		sql.append("ON a.oid = c.taskId WHERE c.oid = " + taskId);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if (CollectionUtil.isNotEmpty(list)) {
			list.forEach(obj -> {
				Map<String, Object> map = (HashMap<String, Object>) obj;
				User user = BeanUtil.mapToBean(map, User.class, true);
				userList.add(user);
			});
		}
		if (CollectionUtil.isNotEmpty(userList)) {
			return userList.get(0);
		}
		return null;
	}

	@Override
	public List<Map<String, Object>> selectExpertBySurveyTaskIdList(StringBuilder taskIdList) {
		List<Map<String, Object>> userList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("SELECT a.oid as taskId, b.realName,b.phone FROM risk_task a INNER JOIN risk_se_user b ");
		sql.append("ON a.expert_id = b.oid  INNER JOIN risk_surveytask c  ");
		sql.append("ON a.oid = c.taskId WHERE c.oid in (" + taskIdList + ")");
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if (CollectionUtil.isNotEmpty(list)) {
			list.forEach(obj -> {
				Map<String, Object> map = (HashMap<String, Object>) obj;
				userList.add(map);
			});
		}

		return userList;
	}


	/**
	 * 查询阶段专家的记录数
	 * @param taskId
	 * @return
	 */
	@Override
	public Integer selectStepExpert(Long taskId) {
		List<User> userList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("select * from risk_survey_expert t where t.taskId="+taskId);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if(list!=null){
			return list.size();
		}
		return 0;
	}

	@Override
	public String selectStepExpertName(Long taskId) {
		StringBuffer sql = new StringBuffer();
		sql.append("select group_concat(distinct N.realName) as tkExpert \n" +
				"from risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid and M.taskId="+taskId);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if(list!=null && list.size()>0){
			Map<String,Object> map=(Map<String,Object>)list.get(0);
			if(map.get("tkExpert") ==null){
				return "--";
			}else{
				return map.get("tkExpert").toString();
			}
		}
		return "--";
	}

	@Override
	public String selectStepExpertName(Long taskId,String surveyStep) {
		StringBuffer sql = new StringBuffer();
		sql.append("select concat(N.realName,' ',N.phone) as tkExpert \n" +
				"from risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid and M.taskId="+taskId);
		sql.append(" and M.surveyStep='"+surveyStep+"'");
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if(list!=null && list.size()>0){
			Map<String,Object> map=(Map<String,Object>)list.get(0);
			if(map.get("tkExpert") ==null){
				return "--";
			}else{
				return map.get("tkExpert").toString();
			}
		}
		return "--";
	}

	/**
	 * 获取专家申请界面的踏勘阶段
	 * @param taskId
	 * @return
	 */
	@Override
	public List<SurveyStep> selectApplyExpertStep(Long taskId){
		StringBuffer sql = new StringBuffer();
		List<SurveyStep> listStep=new ArrayList<>();
		listStep.add(SurveyStep.FIRST);
		listStep.add(SurveyStep.SECOND);
		listStep.add(SurveyStep.THIRD);

		sql.append("select surveyStep from risk_survey_expert M where M.taskId="+taskId);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if(list!=null && list.size()>0){
			for(Object o : list){
				Map<String,Object> map=(Map<String,Object>)o;
				String surveyStep=map.get("surveyStep").toString();
				SurveyStep tmp=SurveyStep.convert(surveyStep);
				// 移除已经有专家的阶段
				listStep.remove(tmp);
			}

		}
		return listStep;
	}


}
