package com.bcxin.hb.hbzw;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 办理环节表
 * @author wangjianjun
 * @date 2020/8/17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PreNode extends Model<PreNode> {
    /**
     * 唯一标识
     */
    private String UNID;

    /**
     * 版本号
     */
    private Integer DATAVERSION;

    /**
     * 办件编号
     */
    private String PROJID;

    /**
     * 业务动作
     */
    private String ACTION;

    /**
     * 办理环节名称
     */
    private String NODE_NAME;

    /**
     * 审批人姓名
     */
    private String NAME;

    /**
     * 审批意见
     */
    private String OPINION;

    /**
     * 环节开始时间
     */
    private Date START_TIME;

    /**
     * 环节结束时间
     */
    private Date END_TIME;

    /**
     * 备注
     */
    private String REMARK;

    /**
     * 所属系统
     */
    private String BELONGSYSTEM;

    /**
     * 备用字段
     */
    private String EXTEND;

    /**
     * 数据产生时间
     */
    private Date CREATE_TIME;

    private String SYNC_STATUS;

    /**
     * 下一环节名称
     */
    private String NEXT_NODE_NAME;

    /**
     * 办理人所属部门名称
     */
    private String HANDER_DEPTNAME;

    /**
     * 办理人所属部门编码
     */
    private String HANDER_DEPTID;

    /**
     * 办理人所属部门的所在行政区划编码
     */
    private String AREACODE;

    /**
     * 阶段名称
     */
    private String PHASE_NAME;

    /**
     * 阶段编号
     */
    private String PHASE_CODE;

    /**
     * 业务数据交换时间戳
     */
    private Date JH_SJC_DXP;

    /**
     * 业务数据状态
     */
    private String JH_SJZT;

    /**
     * 业务数据上传机构标识
     */
    private String JH_SCJG;

    /**
     * 业务数据上传机构名称
     */
    private String JH_SCJGMC;

    /**
     * 业务数据目标机构标识
     */
    private String JH_MBJG;

    /**
     * 1推送到一窗大厅，0推送到厅局
     */
    private String JH_YCBJ;

    @Override
    public Serializable pkVal() {
        return null;
    }
}