package com.bcxin.risk.user.domain;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.org.domain.PoliceOrg;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

/**
 * 公安
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_PoliceUser")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class PoliceUser extends User {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = PoliceOrg.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "org_id")
	private PoliceOrg policeOrg; //所属机构
}
