package com.bcxin.risk.sys;


import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import java.util.Date;

/**
 * 系统提示
 *
 * @author 张建华
 */
@Entity
@Table(name = "sys_upgradetips")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SysTips extends BaseBean {

    private static final long serialVersionUID = 1L;


    /**
     * 状态
     */
    private String status;

    /**
     * 站点
     */
    private String website;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 提示标题
     */
    private String title;

    /**
     * 提示内容
     */
    private String content;

    /**
     * 省份代码
     */
    private String provinceCode;

}
