package com.bcxin.risk.report.material.dto;

import lombok.Data;

import java.util.Map;

/**
 * 供承办单位上传材料中菜单页面使用
 */
@Data
public class MaterialFormMenuDTO {

    private String oid;

    private String menuCode;

    private String menuName;

    private String completed;

    private String required;

    private String class_id;

    private String orgId;

    private String orgType;

    private String orgName;

    private String contactName;

    private String contactPhone;


    public MaterialFormMenuDTO(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.menuCode = safeTransfor(map.get("menuCode"));
        this.menuName = safeTransfor(map.get("menuName"));
        this.completed = safeTransfor(map.get("completed"));
        this.required = safeTransfor(map.get("required"));
        this.orgId = safeTransfor(map.get("orgId"));
        this.orgType = safeTransfor(map.get("orgType"));
        this.orgName = safeTransfor(map.get("orgName"));
        this.contactPhone = safeTransfor(map.get("contactPhone"));
        this.class_id = safeTransfor(map.get("class_id"));
        this.contactName = safeTransfor(map.get("contactName"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
