package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;


/**
 * <b>Function </b>客户上传的数据，活动材料
 * 
 * @author LuoPeng
 * @date 2017年1月5日 下午5:39:12
 * @注意事项 </b>
 * <b>
 */
@Entity
@Table(name = "RISK_MaterialFormValue")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormValue extends BaseBean {

	private static final long serialVersionUID = -6071297966397613071L;
	
	/**  对应的活动*/
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	private String userId;
	
	private int seq;
	
	/** 对应的属性 */
	@ManyToOne(targetEntity = MaterialFormAttr.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "attr_id")
	private MaterialFormAttr attr;

	/**  具体值*/
	@Type(type="text")
	private String value;

}
