package com.bcxin.risk.org.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

//承办者字段

/**
 * 传输内网专用-承办方字段
 *
 * @author wangjianjun
 * @date 2020/11/11
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ContractorOrgDto {

    /**
     * 承办方名称
     */
    private String fullName;
    private String pssId;//pss同步过来的id
    /**
     * 承办者类型：1.承办单位，2.政府单位
     */
    private String contractorType;
    /**
     * 联系人
     */
    private String contact;
    /**
     * 联系电话
     */
    private String phone;
    /**
     * 省市区编码
     */
    private String province;
    private String city;
    private String area;
    /**
     * 企业地址
     */
    private String address;
    /**
     * 组织代码
     */
    private String organizationCode;
    /**
     * 营业执照图片地址
     */
    private String orgUrl;
    /**
     * 管理员手机
     */
    private String adminTel;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 申请时间
     */
    private String applyTime;
    /**
     * 是否冻结
     */
    private String isFreeze;
    /**
     * 审批状态 1.通过，2.不通过，其它.审批中
     */
    private String approveStatus;
}
