package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 短信日志，记录所有短信发送记录
 * @author 罗鹏
 */
@Entity
@Table(name = "log_smsLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SMSLog extends BaseBean {

	private static final long serialVersionUID = 7064937058904767154L;

	/**
	 * 手机号
	 */
	private String phone;

	/**
	 * 内容
	 */
	private String content;

	/**
	 * 发送状态
	 */
	private String success;

}
