package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 文件同步标示（用于申报系统生成的文件记录，不记录审批系统同步过来的文件记录）
 */
@Entity
@Table(name = "log_FileSyncLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class FileSyncLog extends BaseBean {

	private static final long serialVersionUID = 7064937058904767154L;

	/**
	 * 同步的文件名称
	 */
	private String fileName;

	/**
	 * 同步的文件目录
	 */
	private String dir;

	/**
	 * 同步状态，默认为未同步
	 */
	private String sync;

	/**
	 * 同步时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date syncTime;

}
