package com.bcxin.risk.contractor.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * @author zhangjianhua
 * @date 2018/4/27
 */
@Entity
@Table(name = "risk_assessment")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Assessment extends BaseBean {

    private static final long serialVersionUID = 1L;
    /**
     * 服务机构名称
     */
    private String name;

    /**
     * 公司介绍
     */
    private String introduce;

    /**
     * 项目经验
     */
    private String experience;

    /**
     * 专家团队：专家A，专家B，专家C
     */
    private String team;

    /**
     * 业务联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 联系地址
     */
    private String address;

    /**
     * 图片URL
     */
    private String logoUrl;

    /**
     * 省份Id
     */
    private  Long provinceId;


    /**
     * 链接模式（0否，1是）
     */
    private String linkMode;

    /**
     * 链接地址
     */
    private String linkUrl;

    /**
     * 背景图片地址
     */
    private String bgpUrl;

    /**
     * 区域一标题
     */
    private String areaOneTitle;

    /**
     * 区域一内容
     */
    private String areaOneContent;

    /**
     * 区域一图片地址
     */
    private String areaOnePicUrl;

    /**
     * 区域二区域标题
     */
    private String areaTwoTitle;

    /**
     * 区域二小标题用英文逗号隔开
     */
    private String areaTwoLittleTitle;

    /**
     * 区域二内容，用英文逗号隔开
     */
    private String areaTwoContent;

    /**
     * 区域二图片地址，用英文逗号隔开
     */
    private String areaTwoPicUrl;

    /**
     * 区域三标题
     */
    private String areaThreeTitle;
    /**
     * 区域三内容
     */
    private String areaThreeContent;

    /**
     * 区域三图片地址
     */
    private String areaThreePicUrl;

    /**
     * 区域四标题
     */
    private String areaFourTitle;

    /**
     * 区域四内容
     */
    private String areaFourContent;

    /**
     * UUID
     */
    private String uuid;

}
