package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.DateUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

import java.util.Objects;

/**
 * 用于异步打包生成材料时，将活动信息放在这里
 */
@Data
public class ActivityPackDTO {

	private String oid;

	private String name;

	private String activityNo;

	private String activityType;

	private String provinceId;

	private String cityId;

	private String areaId;

	private String unitId;

	private String address;

	private String number;

	private String declareTime;//报批时间（第一次提交内网时间）

	private String startDate;

	private String endDate ;

	private String organizer;

	private String sponsor;
	private String sponsorAddress;
	private String zsponsor;

	private String gov;

	private String channel;

	private String primary;

	private String history;

	/* 承办方信息 */
	private String contractName;

	private String contractPhone;

	private String contractAddress;

	private String isBackUp;

	/**
	 * 是否需要风评报告
	 */
	private String isNeedReport;
	/**
	 * 统一组织代码
	 */
	private String organizationCode;

	/**
	 * 评估机构名称
	 */
	private String pgjgName;

	/**
	 * 评估机构资质
	 */
	private String pgjgUrl;
	/**
	 * 活动坐标
	 */
	private String coordinate;
	/**
	 * 活动简介
	 */
	private String introduce;
	/**
	 * 活动简介
	 */
	private String activitySessions;

	public ActivityPackDTO(Activity activity,User user){
		this.oid = String.valueOf(activity.getOid());
		this.activityType = activity.getActivityType();
		this.activityNo = activity.getActivityNo();
		this.provinceId = String.valueOf(activity.getProvince().getOid());
		this.cityId = activity.getCity()!=null?activity.getCity().getOid()+"":"";
		this.areaId = activity.getArea()!=null?activity.getArea().getOid()+"":"";
		this.unitId = activity.getUnit()!=null?String.valueOf(activity.getUnit().getOid()):"";
		this.name = activity.getName();
		this.address = activity.getAddress();
		this.number = activity.getNumber();
		this.declareTime = DateUtil.getCurrentDateTime();
		this.startDate = activity.getStartDate();
		this.endDate = activity.getEndDate();
		this.sponsor = activity.getSponsor();
		this.zsponsor = activity.getZsponsor();
		this.gov = safeTransfor(activity.getGov());
		this.isBackUp=safeTransfor(activity.getIsBackUp());
		if (StringUtil.isEmpty(this.isBackUp)) {
			// 默认0
			this.isBackUp = "0";
		}

		// 非备案项目==> 许可项目
		if(Objects.equals(isBackUp,"0")){
			this.isNeedReport="1";
		} else {
			this.isNeedReport = safeTransfor(activity.getNeedReport());
		}

		this.coordinate = activity.getCoordinate();
		this.introduce = activity.getIntroduce();

		this.channel = activity.getChannel();
		this.primary = "1";
		this.history = safeTransfor(activity.getHistory());
		if (user != null) {
			this.contractName = user.getRealName();
			this.contractPhone = user.getCompanyPhone();
			this.contractAddress = user.getProvince_id() + "," + user.getCity_id() + "," + user.getArea_id();
		}

	}

	private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
