package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 活动所属的场馆
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Activity_Venue")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityVenue extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 活动
	 */
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	/**
	 * 场馆
	 */
	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venue_id")
	private Venue venue;
}