/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.DateUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.user.domain.User;
import java.util.Objects;
import lombok.Generated;

public class ActivityPackDTO {
    private String oid;
    private String name;
    private String activityNo;
    private String activityType;
    private String provinceId;
    private String cityId;
    private String areaId;
    private String unitId;
    private String address;
    private String number;
    private String declareTime;
    private String startDate;
    private String endDate;
    private String organizer;
    private String sponsor;
    private String sponsorAddress;
    private String zsponsor;
    private String gov;
    private String channel;
    private String primary;
    private String history;
    private String contractName;
    private String contractPhone;
    private String contractAddress;
    private String isBackUp;
    private String isNeedReport;
    private String organizationCode;
    private String pgjgName;
    private String pgjgUrl;
    private String coordinate;
    private String introduce;
    private String activitySessions;

    public ActivityPackDTO(Activity activity, User user) {
        this.oid = String.valueOf(activity.getOid());
        this.activityType = activity.getActivityType();
        this.activityNo = activity.getActivityNo();
        this.provinceId = String.valueOf(activity.getProvince().getOid());
        this.cityId = activity.getCity() != null ? activity.getCity().getOid() + "" : "";
        this.areaId = activity.getArea() != null ? activity.getArea().getOid() + "" : "";
        this.unitId = activity.getUnit() != null ? String.valueOf(activity.getUnit().getOid()) : "";
        this.name = activity.getName();
        this.address = activity.getAddress();
        this.number = activity.getNumber();
        this.declareTime = DateUtil.getCurrentDateTime();
        this.startDate = activity.getStartDate();
        this.endDate = activity.getEndDate();
        this.sponsor = activity.getSponsor();
        this.zsponsor = activity.getZsponsor();
        this.gov = this.safeTransfor(activity.getGov());
        this.isBackUp = this.safeTransfor(activity.getIsBackUp());
        if (StringUtil.isEmpty(this.isBackUp)) {
            this.isBackUp = "0";
        }
        this.isNeedReport = Objects.equals(this.isBackUp, "0") ? "1" : this.safeTransfor(activity.getNeedReport());
        this.coordinate = activity.getCoordinate();
        this.introduce = activity.getIntroduce();
        this.channel = activity.getChannel();
        this.primary = "1";
        this.history = this.safeTransfor(activity.getHistory());
        if (user != null) {
            this.contractName = user.getRealName();
            this.contractPhone = user.getCompanyPhone();
            this.contractAddress = user.getProvince_id() + "," + user.getCity_id() + "," + user.getArea_id();
        }
    }

    private String safeTransfor(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    @Generated
    public String getOid() {
        return this.oid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getActivityNo() {
        return this.activityNo;
    }

    @Generated
    public String getActivityType() {
        return this.activityType;
    }

    @Generated
    public String getProvinceId() {
        return this.provinceId;
    }

    @Generated
    public String getCityId() {
        return this.cityId;
    }

    @Generated
    public String getAreaId() {
        return this.areaId;
    }

    @Generated
    public String getUnitId() {
        return this.unitId;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getDeclareTime() {
        return this.declareTime;
    }

    @Generated
    public String getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getEndDate() {
        return this.endDate;
    }

    @Generated
    public String getOrganizer() {
        return this.organizer;
    }

    @Generated
    public String getSponsor() {
        return this.sponsor;
    }

    @Generated
    public String getSponsorAddress() {
        return this.sponsorAddress;
    }

    @Generated
    public String getZsponsor() {
        return this.zsponsor;
    }

    @Generated
    public String getGov() {
        return this.gov;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public String getPrimary() {
        return this.primary;
    }

    @Generated
    public String getHistory() {
        return this.history;
    }

    @Generated
    public String getContractName() {
        return this.contractName;
    }

    @Generated
    public String getContractPhone() {
        return this.contractPhone;
    }

    @Generated
    public String getContractAddress() {
        return this.contractAddress;
    }

    @Generated
    public String getIsBackUp() {
        return this.isBackUp;
    }

    @Generated
    public String getIsNeedReport() {
        return this.isNeedReport;
    }

    @Generated
    public String getOrganizationCode() {
        return this.organizationCode;
    }

    @Generated
    public String getPgjgName() {
        return this.pgjgName;
    }

    @Generated
    public String getPgjgUrl() {
        return this.pgjgUrl;
    }

    @Generated
    public String getCoordinate() {
        return this.coordinate;
    }

    @Generated
    public String getIntroduce() {
        return this.introduce;
    }

    @Generated
    public String getActivitySessions() {
        return this.activitySessions;
    }

    @Generated
    public void setOid(String oid) {
        this.oid = oid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setActivityNo(String activityNo) {
        this.activityNo = activityNo;
    }

    @Generated
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    @Generated
    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    @Generated
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    @Generated
    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    @Generated
    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setDeclareTime(String declareTime) {
        this.declareTime = declareTime;
    }

    @Generated
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    @Generated
    public void setSponsor(String sponsor) {
        this.sponsor = sponsor;
    }

    @Generated
    public void setSponsorAddress(String sponsorAddress) {
        this.sponsorAddress = sponsorAddress;
    }

    @Generated
    public void setZsponsor(String zsponsor) {
        this.zsponsor = zsponsor;
    }

    @Generated
    public void setGov(String gov) {
        this.gov = gov;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public void setPrimary(String primary) {
        this.primary = primary;
    }

    @Generated
    public void setHistory(String history) {
        this.history = history;
    }

    @Generated
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @Generated
    public void setContractPhone(String contractPhone) {
        this.contractPhone = contractPhone;
    }

    @Generated
    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    @Generated
    public void setIsBackUp(String isBackUp) {
        this.isBackUp = isBackUp;
    }

    @Generated
    public void setIsNeedReport(String isNeedReport) {
        this.isNeedReport = isNeedReport;
    }

    @Generated
    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    @Generated
    public void setPgjgName(String pgjgName) {
        this.pgjgName = pgjgName;
    }

    @Generated
    public void setPgjgUrl(String pgjgUrl) {
        this.pgjgUrl = pgjgUrl;
    }

    @Generated
    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    @Generated
    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }

    @Generated
    public void setActivitySessions(String activitySessions) {
        this.activitySessions = activitySessions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityPackDTO)) {
            return false;
        }
        ActivityPackDTO other = (ActivityPackDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$oid = this.getOid();
        String other$oid = other.getOid();
        if (this$oid == null ? other$oid != null : !this$oid.equals(other$oid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$activityNo = this.getActivityNo();
        String other$activityNo = other.getActivityNo();
        if (this$activityNo == null ? other$activityNo != null : !this$activityNo.equals(other$activityNo)) {
            return false;
        }
        String this$activityType = this.getActivityType();
        String other$activityType = other.getActivityType();
        if (this$activityType == null ? other$activityType != null : !this$activityType.equals(other$activityType)) {
            return false;
        }
        String this$provinceId = this.getProvinceId();
        String other$provinceId = other.getProvinceId();
        if (this$provinceId == null ? other$provinceId != null : !this$provinceId.equals(other$provinceId)) {
            return false;
        }
        String this$cityId = this.getCityId();
        String other$cityId = other.getCityId();
        if (this$cityId == null ? other$cityId != null : !this$cityId.equals(other$cityId)) {
            return false;
        }
        String this$areaId = this.getAreaId();
        String other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !this$areaId.equals(other$areaId)) {
            return false;
        }
        String this$unitId = this.getUnitId();
        String other$unitId = other.getUnitId();
        if (this$unitId == null ? other$unitId != null : !this$unitId.equals(other$unitId)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$declareTime = this.getDeclareTime();
        String other$declareTime = other.getDeclareTime();
        if (this$declareTime == null ? other$declareTime != null : !this$declareTime.equals(other$declareTime)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        String this$organizer = this.getOrganizer();
        String other$organizer = other.getOrganizer();
        if (this$organizer == null ? other$organizer != null : !this$organizer.equals(other$organizer)) {
            return false;
        }
        String this$sponsor = this.getSponsor();
        String other$sponsor = other.getSponsor();
        if (this$sponsor == null ? other$sponsor != null : !this$sponsor.equals(other$sponsor)) {
            return false;
        }
        String this$sponsorAddress = this.getSponsorAddress();
        String other$sponsorAddress = other.getSponsorAddress();
        if (this$sponsorAddress == null ? other$sponsorAddress != null : !this$sponsorAddress.equals(other$sponsorAddress)) {
            return false;
        }
        String this$zsponsor = this.getZsponsor();
        String other$zsponsor = other.getZsponsor();
        if (this$zsponsor == null ? other$zsponsor != null : !this$zsponsor.equals(other$zsponsor)) {
            return false;
        }
        String this$gov = this.getGov();
        String other$gov = other.getGov();
        if (this$gov == null ? other$gov != null : !this$gov.equals(other$gov)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$primary = this.getPrimary();
        String other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !this$primary.equals(other$primary)) {
            return false;
        }
        String this$history = this.getHistory();
        String other$history = other.getHistory();
        if (this$history == null ? other$history != null : !this$history.equals(other$history)) {
            return false;
        }
        String this$contractName = this.getContractName();
        String other$contractName = other.getContractName();
        if (this$contractName == null ? other$contractName != null : !this$contractName.equals(other$contractName)) {
            return false;
        }
        String this$contractPhone = this.getContractPhone();
        String other$contractPhone = other.getContractPhone();
        if (this$contractPhone == null ? other$contractPhone != null : !this$contractPhone.equals(other$contractPhone)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        String this$isBackUp = this.getIsBackUp();
        String other$isBackUp = other.getIsBackUp();
        if (this$isBackUp == null ? other$isBackUp != null : !this$isBackUp.equals(other$isBackUp)) {
            return false;
        }
        String this$isNeedReport = this.getIsNeedReport();
        String other$isNeedReport = other.getIsNeedReport();
        if (this$isNeedReport == null ? other$isNeedReport != null : !this$isNeedReport.equals(other$isNeedReport)) {
            return false;
        }
        String this$organizationCode = this.getOrganizationCode();
        String other$organizationCode = other.getOrganizationCode();
        if (this$organizationCode == null ? other$organizationCode != null : !this$organizationCode.equals(other$organizationCode)) {
            return false;
        }
        String this$pgjgName = this.getPgjgName();
        String other$pgjgName = other.getPgjgName();
        if (this$pgjgName == null ? other$pgjgName != null : !this$pgjgName.equals(other$pgjgName)) {
            return false;
        }
        String this$pgjgUrl = this.getPgjgUrl();
        String other$pgjgUrl = other.getPgjgUrl();
        if (this$pgjgUrl == null ? other$pgjgUrl != null : !this$pgjgUrl.equals(other$pgjgUrl)) {
            return false;
        }
        String this$coordinate = this.getCoordinate();
        String other$coordinate = other.getCoordinate();
        if (this$coordinate == null ? other$coordinate != null : !this$coordinate.equals(other$coordinate)) {
            return false;
        }
        String this$introduce = this.getIntroduce();
        String other$introduce = other.getIntroduce();
        if (this$introduce == null ? other$introduce != null : !this$introduce.equals(other$introduce)) {
            return false;
        }
        String this$activitySessions = this.getActivitySessions();
        String other$activitySessions = other.getActivitySessions();
        return !(this$activitySessions == null ? other$activitySessions != null : !this$activitySessions.equals(other$activitySessions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActivityPackDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oid = this.getOid();
        result = result * 59 + ($oid == null ? 43 : $oid.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $activityNo = this.getActivityNo();
        result = result * 59 + ($activityNo == null ? 43 : $activityNo.hashCode());
        String $activityType = this.getActivityType();
        result = result * 59 + ($activityType == null ? 43 : $activityType.hashCode());
        String $provinceId = this.getProvinceId();
        result = result * 59 + ($provinceId == null ? 43 : $provinceId.hashCode());
        String $cityId = this.getCityId();
        result = result * 59 + ($cityId == null ? 43 : $cityId.hashCode());
        String $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : $areaId.hashCode());
        String $unitId = this.getUnitId();
        result = result * 59 + ($unitId == null ? 43 : $unitId.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $declareTime = this.getDeclareTime();
        result = result * 59 + ($declareTime == null ? 43 : $declareTime.hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        String $organizer = this.getOrganizer();
        result = result * 59 + ($organizer == null ? 43 : $organizer.hashCode());
        String $sponsor = this.getSponsor();
        result = result * 59 + ($sponsor == null ? 43 : $sponsor.hashCode());
        String $sponsorAddress = this.getSponsorAddress();
        result = result * 59 + ($sponsorAddress == null ? 43 : $sponsorAddress.hashCode());
        String $zsponsor = this.getZsponsor();
        result = result * 59 + ($zsponsor == null ? 43 : $zsponsor.hashCode());
        String $gov = this.getGov();
        result = result * 59 + ($gov == null ? 43 : $gov.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : $primary.hashCode());
        String $history = this.getHistory();
        result = result * 59 + ($history == null ? 43 : $history.hashCode());
        String $contractName = this.getContractName();
        result = result * 59 + ($contractName == null ? 43 : $contractName.hashCode());
        String $contractPhone = this.getContractPhone();
        result = result * 59 + ($contractPhone == null ? 43 : $contractPhone.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        String $isBackUp = this.getIsBackUp();
        result = result * 59 + ($isBackUp == null ? 43 : $isBackUp.hashCode());
        String $isNeedReport = this.getIsNeedReport();
        result = result * 59 + ($isNeedReport == null ? 43 : $isNeedReport.hashCode());
        String $organizationCode = this.getOrganizationCode();
        result = result * 59 + ($organizationCode == null ? 43 : $organizationCode.hashCode());
        String $pgjgName = this.getPgjgName();
        result = result * 59 + ($pgjgName == null ? 43 : $pgjgName.hashCode());
        String $pgjgUrl = this.getPgjgUrl();
        result = result * 59 + ($pgjgUrl == null ? 43 : $pgjgUrl.hashCode());
        String $coordinate = this.getCoordinate();
        result = result * 59 + ($coordinate == null ? 43 : $coordinate.hashCode());
        String $introduce = this.getIntroduce();
        result = result * 59 + ($introduce == null ? 43 : $introduce.hashCode());
        String $activitySessions = this.getActivitySessions();
        result = result * 59 + ($activitySessions == null ? 43 : $activitySessions.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ActivityPackDTO(oid=" + this.getOid() + ", name=" + this.getName() + ", activityNo=" + this.getActivityNo() + ", activityType=" + this.getActivityType() + ", provinceId=" + this.getProvinceId() + ", cityId=" + this.getCityId() + ", areaId=" + this.getAreaId() + ", unitId=" + this.getUnitId() + ", address=" + this.getAddress() + ", number=" + this.getNumber() + ", declareTime=" + this.getDeclareTime() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", organizer=" + this.getOrganizer() + ", sponsor=" + this.getSponsor() + ", sponsorAddress=" + this.getSponsorAddress() + ", zsponsor=" + this.getZsponsor() + ", gov=" + this.getGov() + ", channel=" + this.getChannel() + ", primary=" + this.getPrimary() + ", history=" + this.getHistory() + ", contractName=" + this.getContractName() + ", contractPhone=" + this.getContractPhone() + ", contractAddress=" + this.getContractAddress() + ", isBackUp=" + this.getIsBackUp() + ", isNeedReport=" + this.getIsNeedReport() + ", organizationCode=" + this.getOrganizationCode() + ", pgjgName=" + this.getPgjgName() + ", pgjgUrl=" + this.getPgjgUrl() + ", coordinate=" + this.getCoordinate() + ", introduce=" + this.getIntroduce() + ", activitySessions=" + this.getActivitySessions() + ")";
    }
}

