var myScroll, pullUpEl, pullUpOffset;
var p = { limit: 5, offset: 0 };
function getData(){
    g_ajax("/weixin/primaryPage/query",p ,function(json){
        var el, li, i;
        var rows = json.rows;
        var total = json.total;
        el = document.getElementById('thelist');
        if(rows.length==0) { //长度为空，或者小于limit条数，说明是已经到最后了
            $("#pullUp").hide();
            $("#ert").text('数据已经加载完了！').show();
            return;
        }else{
            p.offset += p.limit;
        }
        for(var i in rows){
            var status = rows[i].status=="0"?"未结算":"已结算";
            li = document.createElement('li');
            li.innerHTML =
                '<div class="bill-head">'
                + '<span>'+ rows[i].order_date  + '</span>'
                + '<a href="/weixin/bill/detail/'+rows[i].id+'" >点击查看详情 ></a>'
                + '</div>'
                + '<div class="bill-text">'
                + '<p>'
                + '<span>'
                + '<img src="/static/weixin/images/home-aa.png" />'
                + rows[i].product_name
                     +( rows[i].project_name ? "—"+rows[i].project_name : " ")
                + '</span>'
                + '</span>'
                + '<i>'
                + 'X'+ rows[i].cnt
                + '</i>'
                + '</p>'
                + '<p class="jie">'
                + '<span>'
                + status
                + '</span>'
                + '<i>'
                + '+'+ rows[i].actual_brokerage +"元"
                + '</i>'
                + '</p>'
                + '</div>';
            el.appendChild(li, el.childNodes[0]);
        }
    },false);
}
function pullUpAction () {
    getData();
    myScroll.refresh();		// 数据加载完成后，调用界面更新方法 Remember to refresh when contents are loaded (ie: on ajax completion)
}

$(document).ready(function(){
    // pullUpAction (); // 初始化加载
    getData();

    $("#getAll").click(function(){
        p={ limit: 9999999, offset: 0 };
        getData();
    });
});



/**
 * 初始化iScroll控件
 */
function loaded() {

    pullUpEl = document.getElementById('pullUp');
    pullUpOffset = pullUpEl.offsetHeight;

    myScroll = new iScroll('wrapper', {
        scrollbarClass: 'myScrollbar', /* 重要样式 */
        scrollbars: true,
        mouseWheel: true,//允许滑轮滚动
        useTransition: false, /* 此属性不知用意，本人从true改为false 动画 */
        onRefresh: function () {
            if (pullUpEl.className.match('loading')) {
                pullUpEl.className = '';
                pullUpEl.querySelector('.pullUpLabel').innerHTML = '上拉加载更多...';
            }
        },
        onScrollMove: function () {
            if (this.y < (this.maxScrollY - 55) && !pullUpEl.className.match('flip')) {
                pullUpEl.className = 'flip';
                pullUpEl.querySelector('.pullUpLabel').innerHTML = '松手开始更新...';
                this.maxScrollY = this.maxScrollY;
            } else if (this.y > (this.maxScrollY + 55) && pullUpEl.className.match('flip')) {
                pullUpEl.className = '';
                pullUpEl.querySelector('.pullUpLabel').innerHTML = '上拉加载更多...';
                this.maxScrollY = pullUpOffset;
            }
        },
        onScrollEnd: function () {
            if (pullUpEl.className.match('flip')) {
                pullUpEl.className = 'loading';
                pullUpEl.querySelector('.pullUpLabel').innerHTML = '正在加载...';
                pullUpAction();	// Execute custom function (ajax call?)
            }
        }
    });

    setTimeout(function () { document.getElementById('wrapper').style.left = '0'; }, 800);
}

//初始化绑定iScroll控件
document.addEventListener('touchmove', function (e) { e.preventDefault(); }, false);
document.addEventListener('DOMContentLoaded', loaded, false);



