package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.management.relation.Role;
import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "rbac_subjects")
@Entity
public class SubjectEntity extends EntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "name", length = 100, nullable = false)
    private String name;
    /**
     * OrganId, 平台, 甚至是其他
     */
    @Column(name = "referenced_id", nullable = false, length = 200)
    private String referencedId;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @OneToMany(mappedBy = "subject")
    private Collection<RoleEntity> roles;

    @OneToMany(mappedBy = "subject")
    private Collection<UserEntity> users;

    protected SubjectEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static SubjectEntity create(String name, String referencedId) {
        SubjectEntity subject = new SubjectEntity();
        subject.setId(referencedId);
        subject.setName(name);
        subject.setReferencedId(referencedId);

        return subject;
    }
}
