package com.bcxin.tenant.domain.v5.snapshots.dataexchanges;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
@Setter(AccessLevel.PROTECTED)
public class DepartValueSnapshot extends ValueSnapshot {
    private String id;
    private String code;
    private String name;
    private String parentId;
    private int displayOrder;
    private String domainId;
    private Date createdTime;
    private String departTreeCode;

    private DepartValueSnapshot() {
        this.setCreatedTime(new Date());
    }

    public static DepartValueSnapshot create(
            String id,
            String domainId,
            String code, String name, String parentId, int displayOrder,String departTreeCode) {
        DepartValueSnapshot departValueSnapshot = new DepartValueSnapshot();
        departValueSnapshot.setId(id);
        departValueSnapshot.setDomainId(domainId);
        departValueSnapshot.setCode(code);
        departValueSnapshot.setName(name);
        departValueSnapshot.setDisplayOrder(displayOrder);
        departValueSnapshot.setParentId(parentId);
        departValueSnapshot.setDepartTreeCode(departTreeCode);

        return departValueSnapshot;
    }

    @Override
    protected PriorityValue getPriority() {
        return PriorityValue.Depart;
    }
}
