package com.bcxin.tenant.domain.v5.repositories;

import com.bcxin.tenant.domain.v5.entities.TDepartmentUserEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface TDepartmentUserRepository extends JpaRepository<TDepartmentUserEntity,String> {
    @Query("select d from TDepartmentUserEntity d where d.userId in (select u.id from TUserEntity u where u.domainId=?1 and u.id in (?2))")
    Collection<TDepartmentUserEntity> getByOrganIdAndUserIds(String organId, Collection<String> userIds);

    @Modifying
    @Query("delete from TDepartmentUserEntity where userId in (select id from TUserEntity u where u.domainId=?1 and u.id=?2)")
    void deleteByOrganIdAndUserId(String organId, String userId);


    @Query("select k from TDepartmentUserEntity k where k.userId in (select id from TUserEntity u where u.domainId=?1 and u.id in (?2))")
    Collection<TDepartmentUserEntity> getByIds(String organId, Collection<String> userIds);
}
