package com.bcxin.tenant.domain.v5.business.repositories.impls;

import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.domain.v5.business.dtos.AppPackageReadonlyDto;
import com.bcxin.tenant.domain.v5.business.repositories.SettingRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@Component
public class SettingRepositoryImpl implements SettingRepository {
    private final static String QUERY_APP_PACKAGE_SQL_TEMPLATE =
            "SELECT id,(select GROUP_CONCAT(item_app_id SEPARATOR ';') from tlk_package_app_list where item_package_id=a.id GROUP BY item_package_id) as ITEM_OWN_APPS,ITEM_REGISTERADDRESS,ITEM_REGISTERADDRESSID,ITEM_BAOFFICETYPE FROM tlk_app_package a where ITEM_REGISTERADDRESS=? and ITEM_BAOFFICETYPE=?";
    private final static String QUERY_APP_PACKAGE_SQL_TEMPLATE_FOR_REGULATORY =
            "SELECT id,(select GROUP_CONCAT(item_app_id SEPARATOR ';') from tlk_package_app_list where item_package_id=a.id GROUP BY item_package_id) as ITEM_OWN_APPS,ITEM_REGISTERADDRESS,ITEM_REGISTERADDRESSID,ITEM_BAOFFICETYPE FROM tlk_app_package a where ITEM_REGISTERADDRESSID=? and ITEM_BAOFFICETYPE=?";

    private final CacheProvider cacheProvider;
    private final DataSource dataSource;

    public SettingRepositoryImpl(CacheProvider cacheProvider,
                                 @Qualifier("organizationAuthDataSource")
                                 DataSource dataSource) {
        this.cacheProvider = cacheProvider;
        this.dataSource = dataSource;
    }

    @Override
    public AppPackageReadonlyDto getBy(String province, String city, String superviseRegionCode, String institutionalCode) {
        AppPackageReadonlyDto data = null;
        try (Connection conn = this.dataSource.getConnection()) {
            ResultSet resultSet = getProvinceAndCity(conn, province, city, superviseRegionCode, institutionalCode, true);
            boolean hasRow = resultSet.next();
            if (!hasRow) {
                resultSet = getProvinceAndCity(conn, province, city, superviseRegionCode, institutionalCode, false);
                hasRow = resultSet.next();
            }
            if (hasRow) {
                data = AppPackageReadonlyDto.create(
                        resultSet.getString(1),
                        resultSet.getString(2), resultSet.getString(3),
                        resultSet.getString(4), resultSet.getString(5));
            } else {
                data = AppPackageReadonlyDto.create(null, "__gZxrYDgj8OpfztxSuUg;__xkeybkGaZa1SboC9GL1", null, null, institutionalCode);
            }

        } catch (SQLException ex) {
            ex.printStackTrace();
            throw new BadTenantException("获取应用包异常");
        }

        return data;
    }

    private ResultSet getProvinceAndCity(Connection conn, String province, String city, String superviseRegionCode,
                                         String institutionalCode, boolean isQueryCity) {
        ResultSet resultSet;
        StringBuilder sb = new StringBuilder();
        try {
            if (institutionalCode.equals("保安服务公司") ||
                    institutionalCode.equals("保安培训机构") ||
                    institutionalCode.equals("自行招用保安员单位") ||
                    institutionalCode.equals("社区警务团队")) {
                PreparedStatement statement = conn.prepareStatement(QUERY_APP_PACKAGE_SQL_TEMPLATE_FOR_REGULATORY);
                sb.append(String.format("sql=%s;", QUERY_APP_PACKAGE_SQL_TEMPLATE_FOR_REGULATORY));
                if (isQueryCity) {
                    statement.setString(1, superviseRegionCode);
                    sb.append(String.format("superviseRegionCode=%s;", superviseRegionCode));
                } else {
                    statement.setString(1, superviseRegionCode.substring(0, 2).concat("0000"));
                    sb.append(String.format("superviseRegionCode=%s;", superviseRegionCode.substring(0, 2).concat("0000")));
                }

                sb.append(String.format("institutionalCode=%s;", institutionalCode));
                statement.setString(2, institutionalCode);
                resultSet = statement.executeQuery();
            } else {
                PreparedStatement statement = conn.prepareStatement(QUERY_APP_PACKAGE_SQL_TEMPLATE);
                sb.append(String.format("sql=%s;", QUERY_APP_PACKAGE_SQL_TEMPLATE));
                if (isQueryCity) {
                    statement.setString(1, String.format("%s%s", province, city));

                    sb.append(String.format("1=%s;", String.format("%s%s", province, city)));
                } else {
                    statement.setString(1, String.format("%s", province));

                    sb.append(String.format("1=%s;", String.format("%s", province)));
                }
                statement.setString(2, institutionalCode);

                sb.append(String.format("2=%s;", institutionalCode));
                resultSet = statement.executeQuery();
            }
            return resultSet;
        } catch (SQLException ex) {
            ex.printStackTrace();
            sb.append(ex.toString());
            throw new BadTenantException("获取应用包异常:" + sb.toString());
        }
    }
}
