package com.bcxin.tenant.domain.v5.business;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import javax.sql.DataSource;

@Configuration
public class BusinessConfig {
    @Bean("organizationAuthDataSourceProperties")
    @ConfigurationProperties("v5.business.organization")
    public DataSourceProperties organizationAuthDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean("organizationAuthDataSource")
    public DataSource organizationAuthDataSource() {
        return organizationAuthDataSourceProperties().initializeDataSourceBuilder().build();
    }
}
