package com.bcxin.api.interfaces.tenants.requests.organizationRelationship;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@ApiModel("修改集团组织详情请求")
@Data
public class OrganizationRelationshipInfoUpdateRequest extends RequestAbstract {
    @ApiModelProperty(value = "id", required = true)
    @NotNull(message = "id不能为空")
    private long id;

    @ApiModelProperty(value = "组织说明")
    private String organizationNote;

    @ApiModelProperty(value = "组织类型")
    private Long organizationTypeId;

    @ApiModelProperty(value = "上级组织")
    private String parentId;

    @ApiModelProperty(value = "上级组织名称")
    private String parentName;

    @ApiModelProperty(value = "上级组织的索引")
    private String parentIndex;

    @ApiModelProperty(value = "组织编码")
    private String code;

    @ApiModelProperty(value = "联系人姓名")
    private String contactName;

    @ApiModelProperty(value = "联系人手机")
    private String contactTelephone;

    @ApiModelProperty(value = "集团Id",hidden = true)
    private String organizationId;
}
