package com.bcxin.api.interfaces.rbacs.custom.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel("企业授权操作项返回对象")
@Data
public class RbacPermitOptionResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "操作项ID")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long optionId;

    @ApiModelProperty(value = "应用ID")
    private Long permitAppId;

    @ApiModelProperty(value = "应用代码")
    private String appCode;

    @ApiModelProperty(value = "操作项类型，1：web，2：app")
    private Integer optionType;

    @ApiModelProperty(value = "操作项代码/菜单id")
    private String optionCode;

    @ApiModelProperty(value = "操作项名称")
    private String optionName;

    @ApiModelProperty(value = "操作项分类")
    private String category;

    @ApiModelProperty(value = "是否勾选，1是，0否")
    private Integer checked = 0;

    @ApiModelProperty(value = "操作项子节点列表")
    private List<RbacPermitOptionResponse> children;

}
