package com.bcxin.api.interfaces.identities.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class PrepareResetPasswordResponse extends ResponseAbstract {
    private final String jwt;
    private final String code;
    private final String mobile;
    private final boolean success;
    private final boolean hasHeadPhoto;

    public PrepareResetPasswordResponse(String jwt, boolean success, String code, String mobile) {
        this.jwt = jwt;
        this.code = code;
        this.mobile = mobile;
        this.success = success;
        this.hasHeadPhoto = false;
    }
    public PrepareResetPasswordResponse(String jwt, boolean success, String code, String mobile,boolean hasHeadPhoto) {
        this.jwt = jwt;
        this.code = code;
        this.mobile = mobile;
        this.success = success;
        this.hasHeadPhoto = hasHeadPhoto;
    }

    public static PrepareResetPasswordResponse create(String jwt, boolean success, String code, String mobile) {
        return new PrepareResetPasswordResponse(jwt, success, code,mobile);
    }
    public static PrepareResetPasswordResponse create(String jwt, boolean success, String code, String mobile,boolean hasHeadPhoto) {
        return new PrepareResetPasswordResponse(jwt, success, code,mobile,hasHeadPhoto);
    }
}
