package com.bcxin.saas.domains.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.utils.StringUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.sql.Timestamp;

@Data
public class HmacAuthEntity implements IAggregate {
    private String clientId;
    private String secret;
    private Timestamp expiredTime;
    private String note;
    private String resource;
    private Timestamp createdTime;

    /**
     * 加密的内容; 对于每个用户都加密不同的值, 此值对于用户不可见
     */
    private String dataToSign;

    public boolean isExpired() {
        return expiredTime.getTime() < System.currentTimeMillis();
    }
}
