/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domains.readers;

import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.domains.dtos.RbacEmployeePermitAppDTO;
import com.bcxin.saas.domains.dtos.RbacEmployeePermitOptionDTO;
import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.entities.RbacAppEntity;
import com.bcxin.saas.domains.readers.RbacDbReader;
import com.bcxin.saas.domains.repositories.RbacAppRepository;
import com.bcxin.saas.domains.repositories.RbacOptionRepository;
import io.jsonwebtoken.lang.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RbacDbReaderImpl
implements RbacDbReader {
    private static final String BASE_SERVICE_APP_CODE = "__zidingyiyingyongPTJCGN";
    private static final String WORKSPACE_OPTION_CODE = "__ZiDingYiCaiDanSuoYouYingYong";
    private static final String KAOQINDAKA_APP_CODE = "__yXF3gCR1rLDkGP9l3Vm";
    private DistributedCacheProvider distributedCacheProvider;
    private RbacAppRepository rbacAppRepository;
    private RbacOptionRepository rbacOptionRepository;

    public RbacDbReaderImpl(DistributedCacheProvider distributedCacheProvider, RbacAppRepository rbacAppRepository, RbacOptionRepository rbacOptionRepository) {
        this.distributedCacheProvider = distributedCacheProvider;
        this.rbacAppRepository = rbacAppRepository;
        this.rbacOptionRepository = rbacOptionRepository;
    }

    @Override
    public RbacEmployeePermitAppDTO getPermitApps(RbacQueryDTO rbacQueryDTO) {
        RbacEmployeePermitAppDTO permitAppDTO = new RbacEmployeePermitAppDTO();
        Set<String> baseServiceOptionsSet = null;
        if (!rbacQueryDTO.isMobile()) {
            rbacQueryDTO.setAppId(BASE_SERVICE_APP_CODE);
            baseServiceOptionsSet = this.getUserPermitOptions(rbacQueryDTO);
            permitAppDTO.setBaseServiceOptions(baseServiceOptionsSet);
        }
        if (rbacQueryDTO.isMobile() || baseServiceOptionsSet != null && baseServiceOptionsSet.contains(WORKSPACE_OPTION_CODE)) {
            RbacAppEntity daKaApp;
            boolean appExist;
            List<RbacAppEntity> appList = this.getWorkspaceApps(rbacQueryDTO);
            if (rbacQueryDTO.isMobile() && !(appExist = appList.stream().anyMatch(entity -> KAOQINDAKA_APP_CODE.equals(entity.getAppCode()))) && (daKaApp = this.rbacAppRepository.findByAppCode(KAOQINDAKA_APP_CODE)) != null) {
                appList.add(daKaApp);
            }
            permitAppDTO.setWorkspaceApps(appList);
        }
        return permitAppDTO;
    }

    private List<RbacAppEntity> getWorkspaceApps(RbacQueryDTO rbacQueryDTO) {
        List<RbacAppEntity> permitsAppSet = this.rbacAppRepository.findPermitApps(rbacQueryDTO);
        List<RbacAppEntity> appList = permitsAppSet.stream().filter(ix -> !ix.getAppCode().equals(BASE_SERVICE_APP_CODE)).collect(Collectors.toList());
        return appList;
    }

    private Set<String> getUserPermitOptions(RbacQueryDTO rbacQueryDTO) {
        Set<String> entity = this.rbacOptionRepository.findPermitOptions(rbacQueryDTO);
        if (Collections.isEmpty(entity)) {
            return new HashSet<String>();
        }
        return entity;
    }

    @Override
    public RbacEmployeePermitOptionDTO getPermitOptions(RbacQueryDTO rbacQueryDTO) {
        RbacEmployeePermitOptionDTO permitAppVO = new RbacEmployeePermitOptionDTO();
        Set<String> permitOptionsSet = this.getUserPermitOptions(rbacQueryDTO);
        permitAppVO.setAppId(rbacQueryDTO.getAppId());
        permitAppVO.setOptions(permitOptionsSet);
        return permitAppVO;
    }
}

