/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.domains.readers;

import com.bcxin.saas.domains.dtos.PageResultDto;
import com.bcxin.saas.domains.dtos.PageSearchDto;
import com.bcxin.saas.domains.entities.EmployeeEntity;
import com.bcxin.saas.domains.readers.EmployeeDbReader;
import com.bcxin.saas.domains.repositories.EmployeeRepository;
import java.util.List;

public class EmployeeDbReaderImpl
implements EmployeeDbReader {
    private final EmployeeRepository employeeRepository;

    public EmployeeDbReaderImpl(EmployeeRepository employeeRepository) {
        this.employeeRepository = employeeRepository;
    }

    @Override
    public PageResultDto getEmployeeByDomainId(PageSearchDto searchDto) {
        List<EmployeeEntity> employeeList = this.employeeRepository.getEmployeeByDomainId(searchDto);
        return PageResultDto.create(searchDto, employeeList);
    }

    @Override
    public PageResultDto getEmployeeByDepartId(PageSearchDto searchDto) {
        List<EmployeeEntity> employeeList = this.employeeRepository.getEmployeeByDepartId(searchDto.getDeptId());
        return PageResultDto.create(searchDto, employeeList);
    }

    @Override
    public PageResultDto getEmployeeByRoleId(PageSearchDto searchDto) {
        List<EmployeeEntity> employeeList = this.employeeRepository.getEmployeeByRoleId(searchDto.getRoleId());
        return PageResultDto.create(searchDto, employeeList);
    }

    @Override
    public PageResultDto getEmployees(PageSearchDto searchDto) {
        List<EmployeeEntity> employeeList = this.employeeRepository.queryEmployees(searchDto);
        return PageResultDto.create(searchDto, employeeList);
    }
}

