package com.teemlink.sync.controller;

import cn.myapps.util.http.RequestFileUtil;
import com.teemlink.sync.model.DataOperation;
import com.teemlink.sync.model.FileOperation;
import com.teemlink.sync.model.log.SyncLog;
import com.teemlink.sync.service.SyncLogService;
import com.teemlink.sync.service.SyncService;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

@RestController
@RequestMapping(path = "/runtime", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ReceiverController {

    @Autowired
    private SyncService service;

    /**
     * 同步表数据
     * @param dataOperation
     * @return
     */
    @PostMapping("/sync/data")
    public ResultData syncData(@RequestBody DataOperation dataOperation){
        int status = 1;
        String msg = "成功";
        try{
            service.syncData(dataOperation);
        } catch (Exception e){
            status = -1;

            e.printStackTrace();
            try(StringWriter sw = new StringWriter()){
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                msg = sw.toString();
                return new ResultData(500, sw.toString());
            } catch (Exception x){
                throw new RuntimeException(x);
            }
        } finally {
            SyncLog log = new SyncLog();
            log.setId(dataOperation.getDataObject().getId());
            log.setAction(dataOperation.getAction());
            log.setActionTime(new Date());
            log.setTableName(dataOperation.getDataObject().getTableName());
            log.setDataOperation(JSONObject.fromObject(dataOperation).toString());
            log.setMsg(msg);
            log.setStatus(status);
            SyncLogService.createOrUpdate(log);
        }
        return new ResultData(0, "ok");
    }

    /**
     * 同步文件
     * @param fileOperation
     * @return
     */
    @PostMapping("/sync/file")
    public ResultData syncFile(@RequestBody FileOperation fileOperation){
        String downloadUrl = fileOperation.getDownloadUrl();
        String pathOnTargetServer = fileOperation.getPathOnTargetServer();

        int status = 1;
        String msg = "成功";
        try{
            boolean result = RequestFileUtil.downLoadFromUrl(downloadUrl, pathOnTargetServer);
            if(result){
                return new ResultData(0, "ok");
            } else {
                status = -1;
                msg = "失败";
                return new ResultData(500, "同步失败");
            }
        } finally {
            SyncLog log = new SyncLog();
            log.setId("");
            log.setAction(FileOperation.ACT_CREATE);
            log.setActionTime(new Date());
            log.setTableName("file");
            log.setDataOperation(JSONObject.fromObject(fileOperation).toString());
            log.setMsg(msg);
            log.setStatus(status);
            SyncLogService.createOrUpdate(log);
        }
    }

}
