package com.jgqz;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import com.jgqz.jgutil.iMsgServer2015;

import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;

/**
 * 
 * @author peter
 * @time 2019-08-16
 */

@Controller(value = "OfficeServer")
@RequestMapping(value = "/api/office/service")
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include = JsonSerialize.Inclusion.NON_NULL)
public class OfficeServer extends AbstractRuntimeController {
	private iMsgServer2015 MsgObj = new iMsgServer2015();
	String mOption;
	String mUserName;
	String mRecordID;
	String mFileName;
	String mFileType;
	String mCommand;
	String mInfo;
	String mTemplate;
	String mContent;
	String mRemoteFile;
	String mImageName;
	String mDataBase;
	byte[] mFileBody;
	int mFileSize = 0;
	String mFilePath; // 取得服务器路径
	String mDirectory;
	String mDescript;
	String mFileDate;
	// 数据库相关功能开始
	// 打印控制
	private String mOfficePrints;
	private int mCopies;
	
	private static final Logger log = LoggerFactory.getLogger(OfficeServer.class);

	// 数据库相关功能结束
	// char[]转byte[]
	public static byte[] getBytes(char[] chars) {
		Charset cs = Charset.forName("UTF-8");
		CharBuffer cb = CharBuffer.allocate(chars.length);
		cb.put(chars);
		cb.flip();
		ByteBuffer bb = cs.encode(cb);
		return bb.array();
	}

	@RequestMapping(value = "/OfficeServer")
	protected void service(HttpServletRequest request, HttpServletResponse response,
			@RequestPart MultipartFile[] FileData) throws ServletException, IOException {
		mCommand = "";
		log.info("OfficeServer.service Start");
		log.info("OfficeServer.service --- request.getSession().getId() = " + request.getSession().getId());

		mFilePath = request.getSession().getServletContext().getRealPath(""); // 取得服务器路径
		String realPath = PropertyUtil.getPath();

		String htmlHttp = "";
		try {
			if (request.getMethod().equalsIgnoreCase("POST")) {// 判断请求方式
				String formd = request.getParameter("FormData");
				MsgObj.setSendType("JSON");
				MsgObj.Load(FileData, formd); // 解析请求
				String savePath = realPath + MsgObj.GetMsgByName("path"); // 存放此文件的绝对路径

				mOption = MsgObj.GetMsgByName("OPTION");// 请求参数
				mUserName = MsgObj.GetMsgByName("USERNAME"); // 取得系统用户
				htmlHttp = MsgObj.GetMsgByName("HTMLHTTP");
				mFileName = MsgObj.GetMsgByName("FILENAME");

				if (mOption.equalsIgnoreCase("SAVEFILE")) {
					log.info("文档上传中");

					if (MsgObj.MsgFileSave(savePath + mFileName)) {
						log.info(mFileName + "文档已经保存成功");
					}
					int i = mFileName.lastIndexOf(".");
//					String fileType = mFileName.substring(i + 1);
					String uuid = mFileName.substring(0, i);
					String rootPath = PropertyUtil.getPath();
//					createSWF(fileType, savePath + File.separator + mFileName, uuid);
					FileWriteUtil.writeKmConvertTask(rootPath,uuid,savePath + File.separator + mFileName);
					MsgObj.MsgTextClear();// 清除文本信息

				} else if (mOption.equalsIgnoreCase("LOADTEMPLATE")) { // 下面的代码为打开服务器数据库里的模板文件
					mTemplate = MsgObj.GetMsgByName("TEMPLATE"); // 取得模板文档类型
					// 本段处理是否调用文档时打开模版，还是套用模版时打开模版。
					MsgObj.MsgTextClear();// 清除文本信息
					log.info("ALLpath = " + realPath + mTemplate);

					if (MsgObj.MsgFileLoad(realPath + mTemplate)) {
						log.info(mTemplate + "文档已经转换成功");
					}

				}

				int codec = 0;
				if (htmlHttp == "BASE64")
					codec = 1;
				MsgObj.Send(response, codec);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.info("OfficeServer.service End");
	}
}
