package com.bcxin.services.commands;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import com.bcxin.enums.ActionStep;
import com.bcxin.saas.core.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class CreatedDocumentCommand extends CommandAbstract {
    private final String appId;
    private final ParamsTable params;
    private final String content;
    private final IUser user;
    private final ActionStep step;
    private final String actId;

    public CreatedDocumentCommand(String appId, String actId, ActionStep step, ParamsTable params, String content, IUser user) {
        this.appId = appId;
        this.step = step;
        this.params = params;
        this.content = content;
        this.user = user;
        this.actId = actId;
    }

    public static CreatedDocumentCommand create(String appId,  String actId, ActionStep step, ParamsTable params, String content, IUser user) {
        return new CreatedDocumentCommand(appId, actId, step, params, content, user);
    }
}
