package com.bcxin.responses;

import com.bcxin.web.commons.responses.ResponseAbstract;
import lombok.Getter;
import org.springframework.web.bind.annotation.GetMapping;

@Getter
public class TriggerDefinitionResponse extends ResponseAbstract {
    private final String appId;
    private final String id;
    private final String taskId;

    public TriggerDefinitionResponse(String appId, String id, String taskId) {
        this.appId = appId;
        this.id = id;
        this.taskId = taskId;
    }

    public static TriggerDefinitionResponse create(String appId, String id, String taskId) {
        return new TriggerDefinitionResponse(appId, id, taskId);
    }
}
