package com.bcxin.responses;

import com.bcxin.web.commons.responses.ResponseAbstract;
import lombok.Getter;

import java.util.Date;

@Getter
public class TaskDefinitionResponse extends ResponseAbstract {
    private final String id;
    private final String appId;
    private final String name;
    private final String content;
    private final Date lastExecutedTime;
    private final Date lastModifiedTime;
    private final int executedCount;
    private final int frequency;

    public TaskDefinitionResponse(String appId, String id, String name, String content,
                                  Date lastExecutedTime, Date lastModifiedTime,int executedCount,int frequency) {
        this.id = id;
        this.appId = appId;
        this.name = name;
        this.content = content;
        this.lastExecutedTime = lastExecutedTime;
        this.lastModifiedTime = lastModifiedTime;
        this.executedCount = executedCount;
        this.frequency = frequency;
    }

    public static TaskDefinitionResponse create(String appId, String id, String name, String content,
                                                Date lastExecutedTime, Date lastModifiedTime,int executedCount,int frequency) {
        return new TaskDefinitionResponse(appId, id, name, content, lastExecutedTime, lastModifiedTime, executedCount, frequency);
    }
}
