package com.bcxin.responses;

import com.bcxin.web.commons.responses.ResponseAbstract;
import lombok.Getter;

@Getter
public class FlowDefinitionResponse extends ResponseAbstract {
    private final String id;
    private final String appId;
    private final String name;
    private final String subject;
    private final String flow;

    public FlowDefinitionResponse(String appId,String id, String name, String subject, String flow) {
        this.id = id;
        this.appId = appId;
        this.name = name;
        this.subject = subject;
        this.flow = flow;
    }

    public static FlowDefinitionResponse create(String appId,String id, String name, String subject, String flow) {
        return new FlowDefinitionResponse(appId, id, name, subject, flow);
    }
}
