package com.bcxin.intercepters.values;

import cn.myapps.common.util.StringUtil;
import com.bcxin.saas.core.ValueType;
import lombok.Data;

import java.util.Arrays;

@Data
public class SecretSaltValueType extends ValueType {
    private String secret;
    private String dataToSign;
    private String resource;

    public static SecretSaltValueType create(String secret,String dataToSign,String resource)
    {
        SecretSaltValueType valueType = new SecretSaltValueType();
        valueType.setSecret(secret);
        valueType.setDataToSign(dataToSign);
        valueType.setResource(resource);

        return valueType;
    }

    public boolean isAllowedResource(String rs) {
        if (StringUtil.isBlank(this.getResource()) || "*".equals(this.getResource())) {
            return true;
        }

        return Arrays.stream(this.getResource().split(",")).anyMatch(ix -> rs.contains(ix));
    }
}
